################################################################
## Prepare a release version of rsa-tools
## distribution.mk makefile
## Usage: make -f distribution.mk

include ${RSAT}/makefiles/util.mk

MAKEFILE=${RSAT}/makefiles/distribution.mk
MAKE = make -sk -f ${MAKEFILE}

## Archive file
DATE=`date +%Y%m%d`
ARCHIVE_PREFIX=rsa-tools_${DATE}
ARCHIVE=rsa-tools/${ARCHIVE_PREFIX}

## Archive with tar
#TAR_EXCLUDE=-X CVS '*~' 
TAR_CREATE =tar ${TAR_EXCLUDE} -cpvf ${ARCHIVE}.tar rsa-tools/RSA.config.default rsa-tools/RSAT_config_default.props
TAR =tar ${TAR_EXCLUDE} -rpvf ${ARCHIVE}.tar 

################################################################
## All the tasks for publishing the new version
all: clean_emacs_bk tar_archive clean_distrib_site publish

################################################################
## Generate the Manuals and tutorials
manuals:
	(cd doc/manuals; make fullclean; make install_guide; make rsat_tutorial; make neat_tutorial; make web_server_guide; make tex_clean)
	rsync -rtupvl -e ssh doc/manuals/*.pdf public_html/distrib

## Install manuals on the RSAT Web server
publish_manuals:
	rsync -rtupvl -e ssh doc/manuals/*.pdf rsat@rsat.bigre.ulb.ac.be:rsa-tools/public_html/distrib/


################################################################
## Clean temporary backup files generated by emacs
clean_emacs_bk:
	find perl-scripts -name '*~' -exec rm {} \;
	find perl-scripts -name '.#*' -exec rm {} \;
	find perl-scripts -name '#*' -exec rm {} \;
	find doc -name '*~' -exec rm {} \;
	find doc -name '.#*' -exec rm {} \;
	find doc -name '#*' -exec rm {} \;
	rm -f public_html/*~ public_html/.#* public_html/#*
	rm -f public_html/tutorials/*~ public_html/tutorials/.#* public_html/tutorials/#*

################################################################
## Create tar and zip archives of the whole distribution
POST_CMD=
TAR_ROOT=..
DISTRIB_FILES=rsa-tools/perl-scripts		\
	rsa-tools/RSA.config.default		\
	rsa-tools/RSA.config.default		\
	rsa-tools/makefiles			\
	rsa-tools/doc/manuals/*.pdf		\
	rsa-tools/python-scripts 		\
	rsa-tools/contrib/count-words  		\
	rsa-tools/contrib/matrix-scan-quick  	\
	rsa-tools/ws_clients		  	\
	rsa-tools/contrib/info-gibbs

_fill_archive:
	(cd ${TAR_ROOT};						\
	for f in ${DISTRIB_FILES}; do			\
		${MAKE} _add_one_file FILE=$${f};	\
	done)
	@echo "Archive created	${ARCHIVE}"

_create_tar_archive:
	@echo ${TAR_CREATE} 
	(cd ${TAR_ROOT}; ${TAR_CREATE})

FILE=rsa-tools/perl-scripts
_add_one_file:
	@echo ${ARCHIVE_CMD} ${FILE} ${POST_CMD}
	${ARCHIVE_CMD} ${FILE}  ${POST_CMD}


tar_archive:
	${MAKE} _create_tar_archive
	${MAKE} _fill_archive ARCHIVE_CMD='${TAR}' POST_CMD=''
	(cd ${TAR_ROOT}; gzip -f ${ARCHIVE}.tar)


## Archive with zip
ZIP_EXCLUDE=-x CVS '*~' 
ZIP =zip -ry ${ARCHIVE}.zip 
zip_archive:
	${MAKE} _fill_archive ARCHIVE_CMD='${ZIP}' POST_CMD='${ZIP_EXCLUDE}'


################################################################
## Publish the tar archive of the whole distribution
PUB_LOGIN=jvanheld
PUB_SERVER=rsat.bigre.ulb.ac.be
PUB_DIR=/home/jvanheld/public_html/rsat_distrib/
PUB_FORMAT=tar.gz
clean_distrib_site:
	ssh ${PUB_LOGIN}@${PUB_SERVER} "mv -f ${PUB_DIR}/rsa-tools_*.tar.gz ${PUB_DIR}/previous_versions/"

publish:
	rsync -ruptvl -e ssh ${ARCHIVE_PREFIX}.${PUB_FORMAT} ${PUB_LOGIN}@${PUB_SERVER}:${PUB_DIR}

################################################################
## Make a tar archive of the ws clients
TAR_WSCLIENTS=public_html/web_services/RSATWS_clients.tar.gz
tar_wsclients:
	@rm -f ${TAR_WSCLIENTS}
	tar --exclude CVS  --exclude '*~' --exclude '*.DS_Store' -cvpzf ${TAR_WSCLIENTS} ws_clients
	@echo ${TAR_WSCLIENTS}

publish_tar_wsclients:
	rsync -ruptvl -e ssh ${TAR_WSCLIENTS} rsat@rsat.bigre.ulb.ac.be:rsa-tools/public_html/web_services/

