

import RSATWS.OligoAnalysisRequest;
import RSATWS.OligoAnalysisResponse;
import RSATWS.RSATWSPortType;
import RSATWS.RSATWebServicesLocator;


public class RSATOligoAnalysisClient {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		 try
	        {
			 	/* Get the location of the service */
			 	RSATWebServicesLocator service = new RSATWebServicesLocator();
			 	RSATWSPortType proxy = service.getRSATWSPortType();

	         	            
	            /* prepare the parameters */
	            OligoAnalysisRequest parameters = new OligoAnalysisRequest();
	            	            
	            //sequence :
	            String fastaSeq = ">NP_009651.1    PHO5; upstream from -800 to -1; size: 800; location: NC_001134.7 430946 431745 R; upstream neighbour: NP_009652.1 (distance: 1084)\n" +
	            "TTTTACACATCGGACTGATAAGTTACTACTGCACATTGGCATTAGCTAGGAGGGCATCCAAGTAATAATTGCGAGAAACGTGACCCAACTTTGTTGTAGGT" +
	            "CCGCTCCTTCTAATAATCGCTTGTATCTCTACATATGTTCTATTTACTGACCGAAAGTAGCTCGCTACAATAATAATGTTGACCTGATGTCAGTCCCCACG" +
	            "CTAATAGCGGCGTGTCGCACGCTCTCTTTACAGGACGCCGGAGACCGGCATTACAAGGATCCGAAAGTTGTATTCAACAAGAATGCGCAAATATGTCAACG" +
	            "TATTTGGAAGTCATCTTATGTGCGCTGCTTTAATGTTTTCTCATGTAAGCGGACGTCGTCTATAAACTTCAAACGAAGGTAAAAGGTTCATAGCGCTTTTT" +
	            "CTTTGTCTGCACAAAGAAATATATATTAAATTAGCACGTTTTCGCATAGAACGCAACTGCACAATGCCAAAAAAAGTAAAAGTGATTAAAAGAGTTAATTG" +
	            "AATAGGCAATCTCTAAATGAATCGATACAACCTTGGCACTCACACGTGGGACTAGCACAGACTAAATTTATGATTCTGGTCCCTGTTTTCGAAGAGATCGC" +
	            "ACATGCCAAATTATCAAATTGGTCACCTTACTTGGCAAGGCATATACCCATTTGGGATAAGGGTAAACATCTTTGAATTGTCGAAATGAAACGTATATAAG" +
	            "CGCTGATGTTTTGCTAAGTCGAGGTTAGTATGGCTTCATCTCTCATGAGAATAAGAACAACAACAAATAGAGCAAGCAAATTCGAGATTACCA\n" +
	            ">NP_010769.1    PHO8; upstream from -180 to -1; size: 180; location: NC_001136.8 1420243 1420422 R; upstream neighbour: NP_010770.1 (distance: 180)\n" +
	            "CAGCATTGACGATAGCGATAAGCTTCGCGCGTAGAGGAAAAGTAAAGGGATTTTAGTATATAAAGAAAGAAGTGTATCTAAACGTTTATATTTTTTCGTGC" +
	            "TCCACATTTTGCCAGCAAGTGGCTACATAAACATTTACATATCAGCATACGGGACATTATTTGAACGCGCATTAGCAGC\n" +
	            ">NP_009434.1    PHO11; upstream from -800 to -1; size: 800; location: NC_001133.6 224651 225450 D; upstream neighbour: NP_009431.1 (distance: 2568)\n" +
	            "GCAGCCTCTACCATGTTGCAAGTGCGAACCATACTGTGGCCACATAGATTACAAAAAAAGTCCAGGATATCTTGCAAACCTAGCTTGTTTTGTAAACGACA" +
	            "TTGAAAAAAGCGTATTAAGGTGAAACAATCAAGATTATCTATGCCGATGAAAAATGAAAGGTATGATTTCTGCCACAAATATATAGTAGTTATTTTATACA" +
	            "TCAAGATGAGAAAATAAAGGGATTTTTTCGTTCTTTTATCATTTTCTCTTTCTCACTTCCGACTACTTCTTATATCTACTTTCATCGTTTCATTCATCGTG" +
	            "GGTGTCTAATAAAGTTTTAATGACAGAGATAACCTTGATAAGCTTTTTCTTATACGCTGTGTCACGTATTTATTAAATTACCACGTTTTCGCATAACATTC" +
	            "TGTAGTTCATGTGTACTAAAAAAAAAAAAAAAAAAGAAATAGGAAGGAAAGAGTAAAAAGTTAATAGAAAACAGAACACATCCCTAAACGAAGCCGCACAA" +
	            "TCTTGGCGTTCACACGTGGGTTTAAAAAGGCAAATTACACAGAATTTCAGACCCTGTTTACCGGAGAGATTCCATATTCCGCACGTCACATTGCCAAATTG" +
	            "GTCATCTCACCAGATATGTTATACCCGTTTTGGAATGAGCATAAACAGCGTCGAATTGCCAAGTAAAACGTATATAAGCTCTTACATTTCGATAGATTCAA" +
	            "GCTCAGTTTCGCCTTGGTTGTAAAGTAGGAAGAAGAAGAAGAAGAAGAGGAACAACAACAGCAAAGAGAGCAAGAACATCATCAGAAATACCA\n" +
	            ">NP_011749.1    PHO81; upstream from -800 to -1; size: 800; location: NC_001139.7 958214 959013 R; upstream neighbour: NP_011750.1 (distance: 1694)\n" +
	            "AAACGAGCATGAGGGTTACAAAGAACTTCCGTTTCAAAAATGAATATAATCGTACGTTTACCTTGTGGCAGCACTAGCTAACGCTACGTGGAATGAACGTA" +
	            "CCGTGCCCTATTATTCTTGCTTGTGCTATCTCAAGAATTGCATTTTGTAATAACAACTGCATGGGAAAAATTATATAGATTTTCTACTATTATGTCCGCCT" +
	            "AAGTCAGTTAACCATCTTTATCACAAAATATACAATTAACCAACTACTTAATCAATTCGGTTATATTGCTTAGTATATACGTCTTTGGCACGCGATTGAAA" +
	            "CGCGCTAATTGCATCAGCCTATCTTTCTATGCAAGAATGCAAGAAAAATTGATGTGATGTGCCTTATCACAATTCATTACCTCCTATTTCCTCTGCAGCAA" +
	            "CAAGTTTCCTTGATTATAAAGGTCTTTAGCGTGAGAGGTACAGGTGTTATGGCACGTGCGAATAAGGGCAGAAATTAATCAAATTTATCAACTATTTGGCG" +
	            "ATGGCTCGAGACAGGTATAGAACCACTACTAGGTGATATTGAGGCTTTTGTACAATTTATAGCAAGTTTTTGAGAGTCCCTTCAAGTTTGTTACATAATCT" +
	            "TCTTTGTGCAACGTACAAGAGCAAAGTAGAAAAATTTGGTTTTTATTTTTTTAAGCAACATCAGCTGCACTAGTTGAGCTTTTGACAAGACATACTGCTCA" +
	            "AAAAATCTTCATAACATTATTTTTCGGTTCCACAGTGATTGAGCTTTTTGAGAGAATAACCCTTTGGAGGCAACATAGATAGATAAACGTGCA\n" +
	            ">NP_013583.1    PHO84; upstream from -800 to -1; size: 800; location: NC_001145.2 25802 26601 R; upstream neighbour: NP_013585.1 (distance: 1128)\n" +
	            "AAAAAAAAAGATTCAATAAAAAAAGAAATGAGATCAAAAAAAAAAAAAATTAAAAAAAAAAAGAAACTAATTTATCAGCCGCTCGTTTATCAACCGTTATT" +
	            "ACCAAATTATGAATAAAAAAACCATATTATTATGAAAAGACACAACCGGAAGGGGAGATCACAGACCTTGACCAAGAAAACATGCCAAGAAATGACAGCAA" +
	            "TCAGTATTACGCACGTTGGTGCTGTTATAGGCGCCCTATACGTGCAGCATTTGCTCGTAAGGGCCCTTTCAACTCATCTAGCGGCTATGAAGAAAATGTTG" +
	            "CCCGGCTGAAAAACACCCGTTCCTCTCACTGCCGCACCGCCCGATGCCAATTTAATAGTTCCACGTGGACGTGTTATTTCCAGCACGTGGGGCGGAAATTA" +
	            "GCGACGGCAATTGATTATGGTTCGCCGCAGTCCATCGAAATCAGTGAGATCGGTGCAGTTATGCACCAAATGTCGTGTGAAAGGCTTTCCTTATCCCTCTT" +
	            "CTCCCGTTTTGCCTGCTTATTAGCTAGATTAAAAACGTGCGTATTACTCATTAATTAACCGACCTCATCTATGAGCTAATTATTATTCCTTTTTGGCAGCA" +
	            "TGATGCAACCACATTGCACACCGGTAATGCCAACTTAGATCCACTTACTATTGTGGCTCGTATACGTATATATATAAGCTCATCCTCATCTCTTGTATAAA" +
	            "GTAAAGTTCTAAGTTCACTTCTAAATTTTATCTTTCCTCATCTCGTAGATCACCAGGGCACACAACAAACAAAACTCCACGAATACAATCCAA";
	            
	            parameters.setSequence(fastaSeq);
	            
	            // Length of patterns to be discovered
	            parameters.setLength(6);
	            //Name of the query organism
	            parameters.setOrganism("Saccharomyces_cerevisiae");
	            
	            parameters.setStats("occ,proba,rank");
	            String[] lth_values = {"occ_sig 1"};
	            parameters.setLth(lth_values);
	            
	        	/* Call the service */
	            System.out.println("Calling RSAT server...");
	            OligoAnalysisResponse res = proxy.oligo_analysis(parameters);
	           


	            /* Process results  */  
	            //Report the remote command
	            System.out.println("Command used on the server:"+ res.getCommand());
	            //Report the result
	            System.out.println("Discovered oligo(s):\n"+ res.getClient());
	            //Report the server file location
	            System.out.println("Result file on the server::\n"+ res.getServer());
	        }
	        catch(Exception e) { System.out.println(e.toString()); 
	        }

	}

}
