package MyTypes::OligoAnalysisRequest;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(0);

sub get_xmlns { 'urn:RSATWS' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %output_of :ATTR(:get<output>);
my %verbosity_of :ATTR(:get<verbosity>);
my %sequence_of :ATTR(:get<sequence>);
my %tmp_infile_of :ATTR(:get<tmp_infile>);
my %format_of :ATTR(:get<format>);
my %length_of :ATTR(:get<length>);
my %organism_of :ATTR(:get<organism>);
my %background_of :ATTR(:get<background>);
my %stats_of :ATTR(:get<stats>);
my %noov_of :ATTR(:get<noov>);
my %str_of :ATTR(:get<str>);
my %sort_of :ATTR(:get<sort>);
my %lth_of :ATTR(:get<lth>);
my %uth_of :ATTR(:get<uth>);
my %pseudo_of :ATTR(:get<pseudo>);

__PACKAGE__->_factory(
    [ qw(        output
        verbosity
        sequence
        tmp_infile
        format
        length
        organism
        background
        stats
        noov
        str
        sort
        lth
        uth
        pseudo

    ) ],
    {
        'output' => \%output_of,
        'verbosity' => \%verbosity_of,
        'sequence' => \%sequence_of,
        'tmp_infile' => \%tmp_infile_of,
        'format' => \%format_of,
        'length' => \%length_of,
        'organism' => \%organism_of,
        'background' => \%background_of,
        'stats' => \%stats_of,
        'noov' => \%noov_of,
        'str' => \%str_of,
        'sort' => \%sort_of,
        'lth' => \%lth_of,
        'uth' => \%uth_of,
        'pseudo' => \%pseudo_of,
    },
    {
        'output' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'verbosity' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'sequence' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'tmp_infile' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'format' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'length' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'organism' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'background' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'stats' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'noov' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'str' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'sort' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'lth' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'uth' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'pseudo' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
    },
    {

        'output' => 'output',
        'verbosity' => 'verbosity',
        'sequence' => 'sequence',
        'tmp_infile' => 'tmp_infile',
        'format' => 'format',
        'length' => 'length',
        'organism' => 'organism',
        'background' => 'background',
        'stats' => 'stats',
        'noov' => 'noov',
        'str' => 'str',
        'sort' => 'sort',
        'lth' => 'lth',
        'uth' => 'uth',
        'pseudo' => 'pseudo',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

MyTypes::OligoAnalysisRequest

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
OligoAnalysisRequest from the namespace urn:RSATWS.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * output


=item * verbosity


=item * sequence


=item * tmp_infile


=item * format


=item * length


=item * organism


=item * background


=item * stats


=item * noov


=item * str


=item * sort


=item * lth


=item * uth


=item * pseudo




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # MyTypes::OligoAnalysisRequest
   output =>  $some_value, # string
   verbosity =>  $some_value, # int
   sequence =>  $some_value, # string
   tmp_infile =>  $some_value, # string
   format =>  $some_value, # string
   length =>  $some_value, # int
   organism =>  $some_value, # string
   background =>  $some_value, # string
   stats =>  $some_value, # string
   noov =>  $some_value, # int
   str =>  $some_value, # int
   sort =>  $some_value, # int
   lth =>  $some_value, # string
   uth =>  $some_value, # string
   pseudo =>  $some_value, # string
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

