package MyTypes::PatternAssemblyRequest;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(0);

sub get_xmlns { 'urn:RSATWS' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %output_of :ATTR(:get<output>);
my %input_of :ATTR(:get<input>);
my %tmp_infile_of :ATTR(:get<tmp_infile>);
my %verbosity_of :ATTR(:get<verbosity>);
my %score_col_of :ATTR(:get<score_col>);
my %str_of :ATTR(:get<str>);
my %maxfl_of :ATTR(:get<maxfl>);
my %subst_of :ATTR(:get<subst>);
my %maxcl_of :ATTR(:get<maxcl>);
my %maxpat_of :ATTR(:get<maxpat>);
my %toppat_of :ATTR(:get<toppat>);

__PACKAGE__->_factory(
    [ qw(        output
        input
        tmp_infile
        verbosity
        score_col
        str
        maxfl
        subst
        maxcl
        maxpat
        toppat

    ) ],
    {
        'output' => \%output_of,
        'input' => \%input_of,
        'tmp_infile' => \%tmp_infile_of,
        'verbosity' => \%verbosity_of,
        'score_col' => \%score_col_of,
        'str' => \%str_of,
        'maxfl' => \%maxfl_of,
        'subst' => \%subst_of,
        'maxcl' => \%maxcl_of,
        'maxpat' => \%maxpat_of,
        'toppat' => \%toppat_of,
    },
    {
        'output' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'input' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'tmp_infile' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'verbosity' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'score_col' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'str' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'maxfl' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'subst' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'maxcl' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'maxpat' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'toppat' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
    },
    {

        'output' => 'output',
        'input' => 'input',
        'tmp_infile' => 'tmp_infile',
        'verbosity' => 'verbosity',
        'score_col' => 'score_col',
        'str' => 'str',
        'maxfl' => 'maxfl',
        'subst' => 'subst',
        'maxcl' => 'maxcl',
        'maxpat' => 'maxpat',
        'toppat' => 'toppat',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

MyTypes::PatternAssemblyRequest

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
PatternAssemblyRequest from the namespace urn:RSATWS.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * output


=item * input


=item * tmp_infile


=item * verbosity


=item * score_col


=item * str


=item * maxfl


=item * subst


=item * maxcl


=item * maxpat


=item * toppat




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # MyTypes::PatternAssemblyRequest
   output =>  $some_value, # string
   input =>  $some_value, # string
   tmp_infile =>  $some_value, # string
   verbosity =>  $some_value, # int
   score_col =>  $some_value, # int
   str =>  $some_value, # int
   maxfl =>  $some_value, # int
   subst =>  $some_value, # int
   maxcl =>  $some_value, # int
   maxpat =>  $some_value, # int
   toppat =>  $some_value, # int
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

