package MyTypes::RNSCRequest;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(0);

sub get_xmlns { 'urn:RSATWS' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %inputgraph_of :ATTR(:get<inputgraph>);
my %max_clust_of :ATTR(:get<max_clust>);
my %tabulength_of :ATTR(:get<tabulength>);
my %tabulist_of :ATTR(:get<tabulist>);
my %naive_stop_of :ATTR(:get<naive_stop>);
my %scale_stop_of :ATTR(:get<scale_stop>);
my %exp_nb_of :ATTR(:get<exp_nb>);
my %div_freq_of :ATTR(:get<div_freq>);
my %shf_div_len_of :ATTR(:get<shf_div_len>);

__PACKAGE__->_factory(
    [ qw(        inputgraph
        max_clust
        tabulength
        tabulist
        naive_stop
        scale_stop
        exp_nb
        div_freq
        shf_div_len

    ) ],
    {
        'inputgraph' => \%inputgraph_of,
        'max_clust' => \%max_clust_of,
        'tabulength' => \%tabulength_of,
        'tabulist' => \%tabulist_of,
        'naive_stop' => \%naive_stop_of,
        'scale_stop' => \%scale_stop_of,
        'exp_nb' => \%exp_nb_of,
        'div_freq' => \%div_freq_of,
        'shf_div_len' => \%shf_div_len_of,
    },
    {
        'inputgraph' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'max_clust' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'tabulength' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'tabulist' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'naive_stop' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'scale_stop' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'exp_nb' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'div_freq' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'shf_div_len' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
    },
    {

        'inputgraph' => 'inputgraph',
        'max_clust' => 'max_clust',
        'tabulength' => 'tabulength',
        'tabulist' => 'tabulist',
        'naive_stop' => 'naive_stop',
        'scale_stop' => 'scale_stop',
        'exp_nb' => 'exp_nb',
        'div_freq' => 'div_freq',
        'shf_div_len' => 'shf_div_len',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

MyTypes::RNSCRequest

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
RNSCRequest from the namespace urn:RSATWS.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * inputgraph


=item * max_clust


=item * tabulength


=item * tabulist


=item * naive_stop


=item * scale_stop


=item * exp_nb


=item * div_freq


=item * shf_div_len




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # MyTypes::RNSCRequest
   inputgraph =>  $some_value, # string
   max_clust =>  $some_value, # int
   tabulength =>  $some_value, # int
   tabulist =>  $some_value, # int
   naive_stop =>  $some_value, # int
   scale_stop =>  $some_value, # int
   exp_nb =>  $some_value, # int
   div_freq =>  $some_value, # int
   shf_div_len =>  $some_value, # int
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

