package MyTypes::DisplayGraphRequest;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(0);

sub get_xmlns { 'urn:RSATWS' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %informat_of :ATTR(:get<informat>);
my %outformat_of :ATTR(:get<outformat>);
my %ewidth_of :ATTR(:get<ewidth>);
my %inputgraph_of :ATTR(:get<inputgraph>);
my %wcol_of :ATTR(:get<wcol>);
my %scol_of :ATTR(:get<scol>);
my %tcol_of :ATTR(:get<tcol>);
my %eccol_of :ATTR(:get<eccol>);
my %sccol_of :ATTR(:get<sccol>);
my %tccol_of :ATTR(:get<tccol>);
my %layout_of :ATTR(:get<layout>);

__PACKAGE__->_factory(
    [ qw(        informat
        outformat
        ewidth
        inputgraph
        wcol
        scol
        tcol
        eccol
        sccol
        tccol
        layout

    ) ],
    {
        'informat' => \%informat_of,
        'outformat' => \%outformat_of,
        'ewidth' => \%ewidth_of,
        'inputgraph' => \%inputgraph_of,
        'wcol' => \%wcol_of,
        'scol' => \%scol_of,
        'tcol' => \%tcol_of,
        'eccol' => \%eccol_of,
        'sccol' => \%sccol_of,
        'tccol' => \%tccol_of,
        'layout' => \%layout_of,
    },
    {
        'informat' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'outformat' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'ewidth' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'inputgraph' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'wcol' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'scol' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'tcol' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'eccol' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'sccol' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'tccol' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'layout' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
    },
    {

        'informat' => 'informat',
        'outformat' => 'outformat',
        'ewidth' => 'ewidth',
        'inputgraph' => 'inputgraph',
        'wcol' => 'wcol',
        'scol' => 'scol',
        'tcol' => 'tcol',
        'eccol' => 'eccol',
        'sccol' => 'sccol',
        'tccol' => 'tccol',
        'layout' => 'layout',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

MyTypes::DisplayGraphRequest

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
DisplayGraphRequest from the namespace urn:RSATWS.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * informat


=item * outformat


=item * ewidth


=item * inputgraph


=item * wcol


=item * scol


=item * tcol


=item * eccol


=item * sccol


=item * tccol


=item * layout




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # MyTypes::DisplayGraphRequest
   informat =>  $some_value, # string
   outformat =>  $some_value, # string
   ewidth =>  $some_value, # int
   inputgraph =>  $some_value, # string
   wcol =>  $some_value, # int
   scol =>  $some_value, # int
   tcol =>  $some_value, # int
   eccol =>  $some_value, # int
   sccol =>  $some_value, # int
   tccol =>  $some_value, # int
   layout =>  $some_value, # int
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

