package MyTypes::GraphGetClustersRequest;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(0);

sub get_xmlns { 'urn:RSATWS' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %informat_of :ATTR(:get<informat>);
my %return_of :ATTR(:get<return>);
my %outformat_of :ATTR(:get<outformat>);
my %inputgraph_of :ATTR(:get<inputgraph>);
my %clusters_of :ATTR(:get<clusters>);
my %wcol_of :ATTR(:get<wcol>);
my %scol_of :ATTR(:get<scol>);
my %tcol_of :ATTR(:get<tcol>);
my %distinct_of :ATTR(:get<distinct>);
my %induced_of :ATTR(:get<induced>);

__PACKAGE__->_factory(
    [ qw(        informat
        return
        outformat
        inputgraph
        clusters
        wcol
        scol
        tcol
        distinct
        induced

    ) ],
    {
        'informat' => \%informat_of,
        'return' => \%return_of,
        'outformat' => \%outformat_of,
        'inputgraph' => \%inputgraph_of,
        'clusters' => \%clusters_of,
        'wcol' => \%wcol_of,
        'scol' => \%scol_of,
        'tcol' => \%tcol_of,
        'distinct' => \%distinct_of,
        'induced' => \%induced_of,
    },
    {
        'informat' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'return' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'outformat' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'inputgraph' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'clusters' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'wcol' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'scol' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'tcol' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'distinct' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'induced' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
    },
    {

        'informat' => 'informat',
        'return' => 'return',
        'outformat' => 'outformat',
        'inputgraph' => 'inputgraph',
        'clusters' => 'clusters',
        'wcol' => 'wcol',
        'scol' => 'scol',
        'tcol' => 'tcol',
        'distinct' => 'distinct',
        'induced' => 'induced',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

MyTypes::GraphGetClustersRequest

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
GraphGetClustersRequest from the namespace urn:RSATWS.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * informat


=item * return


=item * outformat


=item * inputgraph


=item * clusters


=item * wcol


=item * scol


=item * tcol


=item * distinct


=item * induced




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # MyTypes::GraphGetClustersRequest
   informat =>  $some_value, # string
   return =>  $some_value, # string
   outformat =>  $some_value, # string
   inputgraph =>  $some_value, # string
   clusters =>  $some_value, # string
   wcol =>  $some_value, # int
   scol =>  $some_value, # int
   tcol =>  $some_value, # int
   distinct =>  $some_value, # int
   induced =>  $some_value, # int
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

