package MyTypes::PurgeSequenceRequest;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(0);

sub get_xmlns { 'urn:RSATWS' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %output_of :ATTR(:get<output>);
my %sequence_of :ATTR(:get<sequence>);
my %tmp_infile_of :ATTR(:get<tmp_infile>);
my %format_of :ATTR(:get<format>);
my %match_length_of :ATTR(:get<match_length>);
my %mismatch_of :ATTR(:get<mismatch>);
my %str_of :ATTR(:get<str>);
my %delete_of :ATTR(:get<delete>);
my %mask_short_of :ATTR(:get<mask_short>);

__PACKAGE__->_factory(
    [ qw(        output
        sequence
        tmp_infile
        format
        match_length
        mismatch
        str
        delete
        mask_short

    ) ],
    {
        'output' => \%output_of,
        'sequence' => \%sequence_of,
        'tmp_infile' => \%tmp_infile_of,
        'format' => \%format_of,
        'match_length' => \%match_length_of,
        'mismatch' => \%mismatch_of,
        'str' => \%str_of,
        'delete' => \%delete_of,
        'mask_short' => \%mask_short_of,
    },
    {
        'output' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'sequence' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'tmp_infile' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'format' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'match_length' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'mismatch' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'str' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'delete' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'mask_short' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
    },
    {

        'output' => 'output',
        'sequence' => 'sequence',
        'tmp_infile' => 'tmp_infile',
        'format' => 'format',
        'match_length' => 'match_length',
        'mismatch' => 'mismatch',
        'str' => 'str',
        'delete' => 'delete',
        'mask_short' => 'mask_short',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

MyTypes::PurgeSequenceRequest

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
PurgeSequenceRequest from the namespace urn:RSATWS.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * output


=item * sequence


=item * tmp_infile


=item * format


=item * match_length


=item * mismatch


=item * str


=item * delete


=item * mask_short




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # MyTypes::PurgeSequenceRequest
   output =>  $some_value, # string
   sequence =>  $some_value, # string
   tmp_infile =>  $some_value, # string
   format =>  $some_value, # string
   match_length =>  $some_value, # int
   mismatch =>  $some_value, # int
   str =>  $some_value, # int
   delete =>  $some_value, # int
   mask_short =>  $some_value, # int
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

