package MyTypes::GraphTopologyRequest;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(0);

sub get_xmlns { 'urn:RSATWS' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %informat_of :ATTR(:get<informat>);
my %all_of :ATTR(:get<all>);
my %return_of :ATTR(:get<return>);
my %inputgraph_of :ATTR(:get<inputgraph>);
my %nodefile_of :ATTR(:get<nodefile>);
my %directed_of :ATTR(:get<directed>);
my %wcol_of :ATTR(:get<wcol>);
my %scol_of :ATTR(:get<scol>);
my %tcol_of :ATTR(:get<tcol>);

__PACKAGE__->_factory(
    [ qw(        informat
        all
        return
        inputgraph
        nodefile
        directed
        wcol
        scol
        tcol

    ) ],
    {
        'informat' => \%informat_of,
        'all' => \%all_of,
        'return' => \%return_of,
        'inputgraph' => \%inputgraph_of,
        'nodefile' => \%nodefile_of,
        'directed' => \%directed_of,
        'wcol' => \%wcol_of,
        'scol' => \%scol_of,
        'tcol' => \%tcol_of,
    },
    {
        'informat' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'all' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'return' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'inputgraph' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'nodefile' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'directed' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'wcol' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'scol' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'tcol' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
    },
    {

        'informat' => 'informat',
        'all' => 'all',
        'return' => 'return',
        'inputgraph' => 'inputgraph',
        'nodefile' => 'nodefile',
        'directed' => 'directed',
        'wcol' => 'wcol',
        'scol' => 'scol',
        'tcol' => 'tcol',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

MyTypes::GraphTopologyRequest

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
GraphTopologyRequest from the namespace urn:RSATWS.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * informat


=item * all


=item * return


=item * inputgraph


=item * nodefile


=item * directed


=item * wcol


=item * scol


=item * tcol




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # MyTypes::GraphTopologyRequest
   informat =>  $some_value, # string
   all =>  $some_value, # int
   return =>  $some_value, # string
   inputgraph =>  $some_value, # string
   nodefile =>  $some_value, # string
   directed =>  $some_value, # int
   wcol =>  $some_value, # int
   scol =>  $some_value, # int
   tcol =>  $some_value, # int
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

