package MyTypes::parsepsixmlRequest;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(0);

sub get_xmlns { 'urn:RSATWS' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %inputfile_of :ATTR(:get<inputfile>);
my %channels_of :ATTR(:get<channels>);
my %interactor_type_of :ATTR(:get<interactor_type>);
my %uth_of :ATTR(:get<uth>);
my %lth_of :ATTR(:get<lth>);

__PACKAGE__->_factory(
    [ qw(        inputfile
        channels
        interactor_type
        uth
        lth

    ) ],
    {
        'inputfile' => \%inputfile_of,
        'channels' => \%channels_of,
        'interactor_type' => \%interactor_type_of,
        'uth' => \%uth_of,
        'lth' => \%lth_of,
    },
    {
        'inputfile' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'channels' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'interactor_type' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'uth' => 'SOAP::WSDL::XSD::Typelib::Builtin::float',
        'lth' => 'SOAP::WSDL::XSD::Typelib::Builtin::float',
    },
    {

        'inputfile' => 'inputfile',
        'channels' => 'channels',
        'interactor_type' => 'interactor_type',
        'uth' => 'uth',
        'lth' => 'lth',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

MyTypes::parsepsixmlRequest

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
parsepsixmlRequest from the namespace urn:RSATWS.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * inputfile


=item * channels


=item * interactor_type


=item * uth


=item * lth




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # MyTypes::parsepsixmlRequest
   inputfile =>  $some_value, # string
   channels =>  $some_value, # string
   interactor_type =>  $some_value, # string
   uth =>  $some_value, # float
   lth =>  $some_value, # float
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

