package MyTypes::DrawHeatmapRequest;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(0);

sub get_xmlns { 'urn:RSATWS' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %output_of :ATTR(:get<output>);
my %outformat_of :ATTR(:get<outformat>);
my %html_of :ATTR(:get<html>);
my %inputfile_of :ATTR(:get<inputfile>);
my %row_names_of :ATTR(:get<row_names>);
my %no_text_of :ATTR(:get<no_text>);
my %col_width_of :ATTR(:get<col_width>);
my %row_height_of :ATTR(:get<row_height>);
my %min_of :ATTR(:get<min>);
my %max_of :ATTR(:get<max>);
my %gradient_of :ATTR(:get<gradient>);

__PACKAGE__->_factory(
    [ qw(        output
        outformat
        html
        inputfile
        row_names
        no_text
        col_width
        row_height
        min
        max
        gradient

    ) ],
    {
        'output' => \%output_of,
        'outformat' => \%outformat_of,
        'html' => \%html_of,
        'inputfile' => \%inputfile_of,
        'row_names' => \%row_names_of,
        'no_text' => \%no_text_of,
        'col_width' => \%col_width_of,
        'row_height' => \%row_height_of,
        'min' => \%min_of,
        'max' => \%max_of,
        'gradient' => \%gradient_of,
    },
    {
        'output' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'outformat' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'html' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'inputfile' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'row_names' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'no_text' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'col_width' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'row_height' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'min' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'max' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'gradient' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
    },
    {

        'output' => 'output',
        'outformat' => 'outformat',
        'html' => 'html',
        'inputfile' => 'inputfile',
        'row_names' => 'row_names',
        'no_text' => 'no_text',
        'col_width' => 'col_width',
        'row_height' => 'row_height',
        'min' => 'min',
        'max' => 'max',
        'gradient' => 'gradient',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

MyTypes::DrawHeatmapRequest

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
DrawHeatmapRequest from the namespace urn:RSATWS.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * output


=item * outformat


=item * html


=item * inputfile


=item * row_names


=item * no_text


=item * col_width


=item * row_height


=item * min


=item * max


=item * gradient




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # MyTypes::DrawHeatmapRequest
   output =>  $some_value, # string
   outformat =>  $some_value, # string
   html =>  $some_value, # int
   inputfile =>  $some_value, # string
   row_names =>  $some_value, # int
   no_text =>  $some_value, # int
   col_width =>  $some_value, # int
   row_height =>  $some_value, # int
   min =>  $some_value, # int
   max =>  $some_value, # int
   gradient =>  $some_value, # string
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

