package MyTypes::RetrieveSequenceRequest;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(0);

sub get_xmlns { 'urn:RSATWS' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %output_of :ATTR(:get<output>);
my %organism_of :ATTR(:get<organism>);
my %query_of :ATTR(:get<query>);
my %all_of :ATTR(:get<all>);
my %noorf_of :ATTR(:get<noorf>);
my %from_of :ATTR(:get<from>);
my %to_of :ATTR(:get<to>);
my %feattype_of :ATTR(:get<feattype>);
my %type_of :ATTR(:get<type>);
my %format_of :ATTR(:get<format>);
my %lw_of :ATTR(:get<lw>);
my %label_of :ATTR(:get<label>);
my %label_sep_of :ATTR(:get<label_sep>);
my %nocom_of :ATTR(:get<nocom>);
my %repeat_of :ATTR(:get<repeat>);
my %imp_pos_of :ATTR(:get<imp_pos>);

__PACKAGE__->_factory(
    [ qw(        output
        organism
        query
        all
        noorf
        from
        to
        feattype
        type
        format
        lw
        label
        label_sep
        nocom
        repeat
        imp_pos

    ) ],
    {
        'output' => \%output_of,
        'organism' => \%organism_of,
        'query' => \%query_of,
        'all' => \%all_of,
        'noorf' => \%noorf_of,
        'from' => \%from_of,
        'to' => \%to_of,
        'feattype' => \%feattype_of,
        'type' => \%type_of,
        'format' => \%format_of,
        'lw' => \%lw_of,
        'label' => \%label_of,
        'label_sep' => \%label_sep_of,
        'nocom' => \%nocom_of,
        'repeat' => \%repeat_of,
        'imp_pos' => \%imp_pos_of,
    },
    {
        'output' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'organism' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'query' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'all' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'noorf' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'from' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'to' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'feattype' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'type' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'format' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'lw' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'label' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'label_sep' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'nocom' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'repeat' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'imp_pos' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
    },
    {

        'output' => 'output',
        'organism' => 'organism',
        'query' => 'query',
        'all' => 'all',
        'noorf' => 'noorf',
        'from' => 'from',
        'to' => 'to',
        'feattype' => 'feattype',
        'type' => 'type',
        'format' => 'format',
        'lw' => 'lw',
        'label' => 'label',
        'label_sep' => 'label_sep',
        'nocom' => 'nocom',
        'repeat' => 'repeat',
        'imp_pos' => 'imp_pos',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

MyTypes::RetrieveSequenceRequest

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
RetrieveSequenceRequest from the namespace urn:RSATWS.

Parameters for the operation retrieve_seq.




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * output


=item * organism


=item * query


=item * all


=item * noorf


=item * from


=item * to


=item * feattype


=item * type


=item * format


=item * lw


=item * label


=item * label_sep


=item * nocom


=item * repeat


=item * imp_pos




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # MyTypes::RetrieveSequenceRequest
   output =>  $some_value, # string
   organism =>  $some_value, # string
   query =>  $some_value, # string
   all =>  $some_value, # int
   noorf =>  $some_value, # int
   from =>  $some_value, # int
   to =>  $some_value, # int
   feattype =>  $some_value, # string
   type =>  $some_value, # string
   format =>  $some_value, # string
   lw =>  $some_value, # int
   label =>  $some_value, # string
   label_sep =>  $some_value, # string
   nocom =>  $some_value, # int
   repeat =>  $some_value, # int
   imp_pos =>  $some_value, # int
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

