################################################################
## initialize the directories for rsa-tools after the first download 

MAKEFILE=${RSAT}/makefiles/init_RSAT.mk
MAKE = make -sk -f ${MAKEFILE}

### tags
usage:
	@echo "usage: make [-OPT='options'] target"
	@echo "implemented targets"
	@perl -ne 'if (/^([a-z]\S+):/){ print "\t$$1\n";  }' ${MAKEFILE}

SUPPORTED_ORGANISMS=public_html/data/supported_organisms.pl
COUNT_FILE=public_html/logs/count-file
CONFIG_FILE=RSA.config
init:
	@echo "Creating directories"
	mkdir -p public_html/data/genomes
	mkdir -p public_html/data/KEGG
	mkdir -p public_html/data/metabolic_networks
	mkdir -p public_html/data/metabolic_networks/GER_files
	mkdir -p public_html/tmp
	mkdir -p public_html/logs
	mkdir -p public_html/logs/peak-footprints_logs; chmod 777 public_html/logs/peak-footprints_logs
	mkdir -p public_html/tmp/peak-footprints_output; chmod 777 public_html/tmp/peak-footprints_output
	mkdir -p bin
	mkdir -p libs
	mkdir -p lib

	chmod 777 public_html/tmp
#	echo "Options -Indexes" > public_html/tmp/.htaccess
#	echo "<html><body>Forbidden</body></html>" > public_html/tmp/index.html
	chmod 777 public_html/logs
#	echo "Options -Indexes" > public_html/logs/.htaccess
#	echo "<html><body>Forbidden</body></html>" > public_html/logs/index.html

	ln -fs public_html/data .
	ln -fs public_html/tmp .
	ln -fs public_html/logs .

	@echo "Checking config files"
	@if [ -f "${SUPPORTED_ORGANISMS}" ] ; then \
		echo "file already exists	${SUPPORTED_ORGANISMS}" ; \
	else \
		echo "creating empty file with supported organisms ${SUPPORTED_ORGANISMS}" ; \
		echo "return 1;" > ${SUPPORTED_ORGANISMS}; \
	fi
	@if [ -f "${COUNT_FILE}" ] ; then \
		echo "file already exists	${COUNT_FILE}" ; \
	else \
		echo "creating count file ${COUNT_FILE}" ; \
		echo "0" > ${COUNT_FILE}; \
	fi
	@if [ -f "${CONFIG_FILE}" ] ; then \
		echo "file already exists	${CONFIG_FILE}" ; \
	else \
		echo "creating config file ${CONFIG_FILE}" ; \
		cp RSA.config.default ${CONFIG_FILE}; \
	fi
	@if [ -f "${RSAT}/RSAT_config.props" ] ; then \
		echo "RSAT property file already exists	${RSAT}/RSAT_config.props" ; \
	else \
		echo "Creating RSAT property file ${RSAT}/RSAT_config.props" ; \
		cp ${RSAT}/RSAT_config_default.props ${RSAT}/RSAT_config.props; \
	fi
	@if [ -f "${RSAT}/RSAT_config.mk" ] ; then \
		echo "RSAT makefiles config already exists	${RSAT}/RSAT_config.mk" ; \
	else \
		echo "Creating RSAT config for makefiles ${RSAT}/RSAT_config.mk" ; \
		cp ${RSAT}/RSAT_config_default.mk ${RSAT}/RSAT_config.mk; \
	fi
	chmod a+w ${COUNT_FILE}

	chmod a+x perl-scripts/*
#	chmod a+x public_html/*.cgi

################################################################
## Import a single genome from the RSAT server
##
## Still not perfect : I did not find the wget options to direct the
## output to public_html/data. I thus take a copy in a fodler named
## rsat.ulb.ac.be, and synchronize it to the real data folder
## data/genomes
WGET=wget --passive-ftp --no-parent --recursive --timestamping --relative --dont-remove-listing --convert-links
RSYNC=rsync
RSAT_DISTRIB=rsat.ulb.ac.be/rsat
ORG=Saccharomyces_cerevisiae
get_one_genome: download_one_genome configure_one_genome

configure_one_genome: 
	install-organism -v 1 -task config,phylogeny -org ${ORG}
	@echo "Organism	${ORG}	 has been updated"

download_one_genome:
	@echo "Downloading genome	${ORG}	from the RSAT server	${RSAT_DISTRIB}"
	${WGET} --reject 'index.html*' -P data/genomes/ -nH  --cut-dirs=3 http://${RSAT_DISTRIB}/data/genomes/${ORG}/

################################################################
## Import a single genome from the RSAT server
## WARNING: this requires a huge disk space (>30Gb)
##
## This is still tricky : the wget protocol cannot obtain the .pl
## files by http. The file supported_organisms.pl can thus not be
## downloaded.  I take a text copy, and I rename it. This is far from
## perfect, it assumes a synchronization between the files
## supported_organisms.txt and supported_organisms.pl
get_all_genomes:
	${WGET} http://${RSAT_DISTRIB}/data/genomes/
	${WGET} http://${RSAT_DISTRIB}/data/supported_organisms.txt 
	rsync -ruptvl ${RSAT_DISTRIB}/data public_html/
	cp ${RSAT}/data/supported_organisms.txt ${RSAT}/data/supported_organisms.pl


################################################################
## Compile and install C/C++ programs that are part of the RSAT
## distribution (since 2009).

## Compile all programs
compile_all: compile_info_gibbs compile_count_words compile_matrix_scan_quick compile_kwalks compile_rea

PROGRAM=info-gibbs
SRC_DIR=${RSAT}/contrib/${PROGRAM}
BIN=${RSAT}/bin
## It may be necessary to run the synchronization as super-user (su) with the command sudo.
## For this, type:
##   make -f makefiles/init_RSAT.mk compile_all SUDO=sudo BIN=[target_dir]
## For instance, on the lab cluster Brussels I run
##   make -f makefiles/init_RSAT.mk compile_all SUDO=sudo BIN=/usr/local/bin
SUDO=
compile_one_program:
	@echo "Compiling ${PROGRAM}"
	(cd ${SRC_DIR}; make all; ${SUDO} rsync -ruptL ${SRC_DIR}/${PROGRAM} ${BIN}/)
#	(cd ${SRC_DIR}; make all; ln -fs ${SRC_DIR}/${PROGRAM} ${RSAT}/bin/${PROGRAM})
	@echo ${BIN}/${PROGRAM}
	@echo ""


## Compile and install info-gibbs (developed by Matthieu Defrance)
compile_info_gibbs:
	@${MAKE} compile_one_program PROGRAM=info-gibbs

## Compile and install count-words (developed by Matthieu Defrance)
compile_count_words:
	@${MAKE} compile_one_program PROGRAM=count-words

compile_matrix_scan_quick:
	@${MAKE} compile_one_program PROGRAM=matrix-scan-quick



################################################################
## Compile the path finding tools

################################################################
## Compile kwalks (subgraph extraction algorithm developed by Jerome
## Callut and Pierre Dupont).
compile_kwalks:
	@echo "Compiling kwalks"
	@(cd ${RSAT}/contrib/kwalks/; \
		tar -xpzf kwalks.tgz; \
		cd kwalks/src; make; \
		cd ../bin; rsync -ruptvl lkwalk ${BIN})
	@chmod 777 ${RSAT}/contrib/kwalks
	@chmod 777 ${RSAT}/contrib/kwalks/kwalks
	@chmod 777 ${RSAT}/contrib/kwalks/kwalks/bin

################################################################
## Compile REA (shortest path finding algorithm)
compile_rea:
	@echo "Compiling REA"
	@(cd ${RSAT}/contrib/REA/; \
		tar -xpzf REA.tgz; \
		make; rsync -ruptvl REA ${BIN})
	@chmod 777 ${RSAT}/contrib/REA
