package MyTypes::TextToHtmlRequest;
use strict;
use warnings;


our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %output_of :ATTR(:get<output>);
my %inputfile_of :ATTR(:get<inputfile>);
my %chunk_of :ATTR(:get<chunk>);
my %no_sort_of :ATTR(:get<no_sort>);
my %font_of :ATTR(:get<font>);

__PACKAGE__->_factory(
    [ qw(        output
        inputfile
        chunk
        no_sort
        font

    ) ],
    {
        'output' => \%output_of,
        'inputfile' => \%inputfile_of,
        'chunk' => \%chunk_of,
        'no_sort' => \%no_sort_of,
        'font' => \%font_of,
    },
    {
        'output' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'inputfile' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'chunk' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'no_sort' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'font' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
    },
    {

        'output' => 'output',
        'inputfile' => 'inputfile',
        'chunk' => 'chunk',
        'no_sort' => 'no_sort',
        'font' => 'font',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

MyTypes::TextToHtmlRequest

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
TextToHtmlRequest from the namespace urn:RSATWS.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * output


=item * inputfile


=item * chunk


=item * no_sort


=item * font




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # MyTypes::TextToHtmlRequest
   output =>  $some_value, # string
   inputfile =>  $some_value, # string
   chunk =>  $some_value, # int
   no_sort =>  $some_value, # int
   font =>  $some_value, # string
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

