#!/usr/bin/perl
############################################################
#
# $Id: gibbs_form.cgi,v 1.10 2011/04/10 13:49:57 jvanheld Exp $
#
# Time-stamp: <2003-07-11 15:08:18 jvanheld>
#
############################################################
#### this cgi script fills the HTML form for the program gibbs
if ($0 =~ /([^(\/)]+)$/) {
    push (@INC, "$`lib/");
}
use CGI;
use CGI::Carp qw/fatalsToBrowser/;
require "RSA.lib";
require "RSA2.cgi.lib";
$ENV{RSA_OUTPUT_CONTEXT} = "cgi";

### Read the CGI query
$query = new CGI;

### default values for filling the form
$default{sequence} = "";
$default{sequence_format} = "fasta";
$default{sequence_file} = "";
$default{upload_file} = "";
$default{length} = 10;
$default{expected} = "auto";
$default{seq_type} = "DNA";
$default{add_rc} = "checked";

### replace defaults by parameters from the cgi call, if defined
foreach $key (keys %default) {
  if ($query->param($key)) {
    $default{$key} = $query->param($key);
  }
} 

### print the form ###
&RSA_header("gibbs", "form");

print "<CENTER>\n";
print "Matrix-based motif discovery using GIBBS<BR>\n";
print "Extract shared motifs from a set of unaligned sequences<BR>\n";
print "Program developed by <A HREF='mailto:neuwald\@cshl.org (Andrew Neuwald)'>Andrew Neuwald</A><BR>\n";
print "Web interface by <A HREF='mailto:jvanheld\@bigre.ulb.ac.be'>Jacques van Helden</A>.\n";
print "</CENTER>\n";

print "<CENTER><font color='red' size=2>\n";
print "<font>We recommend to use the new program <a href='info-gibbs_form.cgi'>info-gibbs</a> rather than this version.";
print "</font></CENTER>\n";


print $query->start_multipart_form(-action=>"gibbs.cgi");

#print "<FONT FACE='Helvetica'>";

#### input sequence
&DisplaySequenceChoice;

### sequence type
print "<A HREF='help.gibbs.html#seq_type'><B>Sequence type</B></A>&nbsp;\n";
print $query->popup_menu(-name=>'seq_type',
			 -Values=>["DNA","protein"],
			 -default=>$default{seq_type});
print "&nbsp;"x10, "\n";

### add reverse complement strand
print "&nbsp;" x 5;
print $query->checkbox(-name=>'add_rc',
		       -checked=>$default{add_rc},
		       -label=>'');
print "<A HREF='help.gibbs.html#add_rc'><B>\n";
print "add reverse complement strand\n";
print "</B></A>\n";

print "<BR>\n";

### matrix length
print "<B><A HREF='help.gibbs.html#length'>\n";
print "Matrix length</A>\n";
print $query->textfield(-name=>'length',
		  -default=>$default{length},
		  -size=>5);
print "<BR>\n";

### expected number of sites
print "<B><A HREF='help.gibbs.html#expected'>\n";
print "Expected number of sites</A>\n";
print $query->textfield(-name=>'expected',
		  -default=>$default{expected},
		  -size=>5);
print "<BR>\n";


### send results by email or display on the browser
&SelectOutput;

### action buttons
print "<UL><UL><TABLE class='formbutton'>\n";
print "<TR VALIGN=MIDDLE>\n";
print "<TD>", $query->submit(-label=>"GO"), "</TD>\n";
print "<TD>", $query->reset, "</TD>\n";
print $query->end_form;

### data for the demo 
print $query->start_multipart_form(-action=>"gibbs_form.cgi");
$demo_sequence = ">GAL1	YBR020W upstream sequence, from -800 to -1
CAGGTTATCAGCAACAACACAGTCATATCCATTCTCAATTAGCTCTACCACAGTGTGTGA
ACCAATGTATCCAGCACCACCTGTAACCAAAACAATTTTAGAAGTACTTTCACTTTGTAA
CTGAGCTGTCATTTATATTGAATTTTCAAAAATTCTTACTTTTTTTTTGGATGGACGCAA
AGAAGTTTAATAATCATATTACATGGCATTACCACCATATACATATCCATATCTAATCTT
ACTTATATGTTGTGGAAATGTAAAGAGCCCCATTATCTTAGCCTAAAAAAACCTTCTCTT
TGGAACTTTCAGTAATACGCTTAACTGCTCATTGCTATATTGAAGTACGGATTAGAAGCC
GCCGAGCGGGCGACAGCCCTCCGACGGAAGACTCTCCTCCGTGCGTCCTCGTCTTCACCG
GTCGCGTTCCTGAAACGCAGATGTGCCTCGCGCCGCACTGCTCCGAACAATAAAGATTCT
ACAATACTAGCTTTTATGGTTATGAAGAGGAAAAATTGGCAGTAACCTGGCCCCACAAAC
CTTCAAATTAACGAATCAAATTAACAACCATAGGATGATAATGCGATTAGTTTTTTAGCC
TTATTTCTGGGGTAATTAATCAGCGAAGCGATGATTTTTGATCTATTAACAGATATATAA
ATGGAAAAGCTGCATAACCACTTTAACTAATACTTTCAACATTTTCAGTTTGTATTACTT
CTTATTCAAATGTCATAAAAGTATCAACAAAAAATTGTTAATATACCTCTATACTTTAAC
GTCAAGGAGAAAAAACTATA
>GAL2	YLR081W upstream sequence, from -800 to -1
CATTAATTTTGCTTCCAAGACGACAGTAATATGTCTCCTACAATACCAGTTTCGCTGCAG
AAGGCACATCTATTACATTTACTGAGCATAACGGGCTGTACTAATCCAAGGAGGTTTACG
GACCAGGGGAACTTTCCAGATTCAGATCACAGCAATATAGGACTAGAAAATATCAGGTAG
CCGCACTCAACTTGTAACTGGCAACTACTTTGCATCAAACTCCAATTAAATGCGGTAGAA
TCTTTTCACAAAAGGTACTCAACGTCAATTCGGAAAGCTTCCTTCCGGAATGGCTTAAGT
AGGTTGCAATTTCTTTTTCTATTAGTAGCTAAAAATGGGTCACGTGATCTATATTCGAAA
GGGGCGGTTGCCTCAGGAAGGCACCGGCGGTCTTTCGTCCGTGCGGAGATATCTGCGCCG
TTCAGGGGTCCATGTGCCTTGGACGATATTAAGGCAGAAGGCAGTATCGGGGCGGATCAC
TCCGAACCGAGATTAGTTAAGCCCTTCCCATCTCAAGATGGGGAGCAAATGGCATTATAC
TCCTGCTAGAAAGTTAACTGTGCACATATTCTTAAATTATACAACATTCTGGAGAGCTAT
TGTTCAAAAAACAAACATTTCGCAGGCTAAAATGTGGAGATAGGATAAGTTTTGTAGACA
TATATAAACAATCAGTAATTGGATTGAAAATTTGGTGTTGTGAATTGCTCTTCATTATGC
ACCTTATTCAATTATCATCAAGAATAGTAATAGTTAAGTAAACACAAGATTAACATAATA
AAAAAAATAATTCTTTCATA
>GAL7	YBR018C upstream sequence, from -800 to -1
GAGAACTGGAAAGATTGTGTAACCTTGAAAAACGGTGAAACTTACGGGTCCAAGATTGTC
TACAGATTTTCCTGATTTGCCAGCTTACTATCCTTCTTGAAAATATGCACTCTATATCTT
TTAGTTCTTAATTGCAACACATAGATTTGCTGTATAACGAATTTTATGCTATTTTTTAAA
TTTGGAGTTCAGTGATAAAAGTGTCACAGCGAATTTCCTCACATGTAGGGACCGAATTGT
TTACAAGTTCTCTGTACCACCATGGAGACATCAAAAATTGAAAATCTATGGAAAGATATG
GACGGTAGCAACAAGAATATAGCACGAGCCGCGGAGTTCATTTCGTTACTTTTGATATCA
CTCACAACTATTGCGAAGCGCTTCAGTGAAAAAATCATAAGGAAAAGTTGTAAATATTAT
TGGTAGTATTCGTTTGGTAAAGTAGAGGGGGTAATTTTTCCCCTTTATTTTGTTCATACA
TTCTTAAATTGCTTTGCCTCTCCTTTTGGAAAGCTATACTTCGGAGCACTGTTGAGCGAA
GGCTCATTAGATATATTTTCTGTCATTTTCCTTAACCCAAAAATAAGGGAAAGGGTCCAA
AAAGCGCTCGGACAACTGTTGACCGTGATCCGAAGGACTGGCTATACAGTGTTCACAAAA
TAGCCAAGCTGAAAATAATGTGTAGCTATGTTCAGTTAGTTTGGCTAGCAAAGATATAAA
AGCAGGTCGGAAATATTTATGGGCATTATTATGCAGAGCATCAACATGATAAAAAAAAAC
AGTTGAATATTCCCTCAAAA
>GAL80	YML051W upstream sequence, from -800 to -1
TATCCTTTACGTTTTGACTTGGTGCTCGAAGATGCTTTCAGAGATGGTGCTTATCCTCAT
GTCTTTTGGGTTTGTCTTCAATACGGCAGCCGTTGTCTTGCAAACGGCCGCCTCTGCCAT
GGCAAAGAATGCTTTCCATGACGATCATCGTAGTGCCCAATTGGGTGCCTCTATGATGGG
TATGGCTTGGGCAAGTGTCTTTTTATGTATCGTGGAATTTATCCTGCTGGTCTTCTGGTC
TGTTAGGGCAAGGTTGGCCTCTACTTACTCCATCGACAATTCAAGATACAGAACCTCCTC
CAGATGGAATCCCTTCCATAGAGAGAAGGAGCAAGCAACTGACCCAATATTGACTGCCAC
TGGACCTGAAGACATGCAACAAAGTGCAAGCATAGTGGGGCCTTCTTCCAATGCTAATCC
GGTCACTGCCACTGCTGCTACGGAAAACCAACCTAAAGGTATTAACTTCTTCACTATAAG
AAAATCACACGAGCGCCCGGACGATGTCTCTGTTTAAATGGCGCAAGTTTTCCGCTTTGT
AATATATATTTATACCCCTTTCTTCTCTCCCCTGCAATATAATAGTTTAATTCTAATATT
AATAATATCCTATATTTTCTTCATTTACCGGCGCACTCTCGCCCGAACGACCTCAAAATG
TCTGCTACATTCATAATAACCAAAAGCTCATAACTTTTTTTTTTGAACCTGAATATATAT
ACATCACATATCACTGCTGGTCCTTGCCGACCAGCGTATACAATCTCGATAGTTGGTTTC
CCGTTCTTTCCACTCCCGTC
>MEL1	YBR184W upstream sequence, from -800 to -1
GCATACTCTACGTTATTTACAAAAATGTCGATATCCATCAAATTTTGTTTGGCGTACAGA
TTGTAGTTGTGGCTGCTACTGCAGGAAGTTTGACGTACAGATACGTCCATGATCCACTTG
CCAAAAGAAATCTCAAGGCTTCAATGGCGCTCGGCGCAATTTTGTTCTTATCTGGCTACA
TTTCGTGGCTACTTGATATACACTATTGTTCGTTCTGGGTGCACGTTAGAAGAAGTATTT
TGGCTTTACCACTTGGTGTACTGCTTGAACCACACGGATGGTGGCATATATTAACTGGTA
TGGGGATTTATTTCTACATTGTTTCTTTGGAACATTTAAGGGTCATTACGCTCAACGTCA
GCTGCAATTACCAGTTCATCTGGAGATGGAAAGTCTTCCCTGAACTGATATGGAAAGGGC
GCAAACCCTCAACAAGATATTCACTTGAACTATTTGGCCCATACGTAGAAGATCAATCAA
TTGAAGTTAAAAAGGAGAAGTAATAATTATAGCATAATATATATTCATAATGTATAGGCA
TATTTATTTTTTATTTTTTTTATTTCATGTTCTATTTAATGACGAATCACGAAGAAAATA
TATCTAAGAAAAGATCTTTTGAATCCTTGATTTGCGAATAGTTTAAATGACCCAGCTTAT
TGCTCTGGTGAAAAAAAACTTTGTGCGGTCTCAAAGCCGTCGGCGGCAAAATAACGTGAA
TTGATGAAAGTAAATAAACAAAACAAAATCTCTAATTGTTGTAACACAAATACTAAGAAA
TTTGTTAGCTAATTCGGGAC
>GCY1	YOR120W upstream sequence, from -800 to -1
GTCTTAGTATCTCATCTCATCTCAATTTCTATATTCCACTATAAAATTTTTCACTCTTTC
TGCGCGCGCCAATGTCCCCGCAACTACTCAATAGGTAACATGAGAATATTTCAGTTCGTA
AGAGAGAAGAGATGAAGTTATTTGGGCTCTTTGCTCGAGGTTACAGAAGGGCCGCATTAG
AGTGAATGAGCTGATGATATTTCGCCCAGTTCTACATTTTTTTTTTTTTGGAAGTATGAC
CTCTGTTAAATTTTTTTTTTTTTAAATTTCACTTTCTAAAGTCCCAGAAATCCGCTTGAA
TGTCTTACATATTGCAATGGATATGCTTGGGTGATCATACTTCCTGGCTTTAGATATTTG
AAACTTAACTCTTGTCAACAAACTTCCTATGGAGTGTATAAGAATTGTAAGTTATAACAC
CGGCGAACAATCGGGGCAGACTATTCCGGGGAAGAACAAGGAAGGGCGGTCTTTTCTCCC
TCATTGTCATAGCAAGGTCATTTCGCCTTCTCAGAAAGGGGTAGAATCAATCTAGCACGC
AGATTGCAAACACGGCTTAATAATATGCCTATCAGGCATTCACCCGTGTGACGAATCGCA
CACCGCTGCTCTCCTTAATTCCCTAGAGTAGAAACCGAGCTTTCAGGAAAAGACTACGGC
AGTAAAGAATTGCTTTACTGGGCGTATAAAACCGGGAGAATCAAGACATTCTAATGACTT
GATTCAGGATGAGAGCTTAATAGGTGCATCTTAGCAAGCTAAAATTTGGACAGCTCTCAT
TACTAAATTAAGATAGAAAA";
print "<TD><B>";
print $query->hidden(-name=>'sequence',-default=>$demo_sequence);
print $query->hidden(-name=>'sequence_format',-default=>"fasta");
print $query->hidden(-name=>'seq_type',-default=>"DNA");
print $query->hidden(-name=>'length',-default=>"25");
print $query->hidden(-name=>'expected',-default=>"auto");
print $query->submit(-label=>"DEMO");
print "</B></TD>\n";
print $query->end_form;


#print "<TD><B><A HREF='demo.gibbs.html'>DEMO</A></B></TD>\n";
print "<TD><B><A HREF='help.gibbs.html'>MANUAL</A></B></TD>\n";
print "<TD><B><A HREF='tutorials/tut_gibbs.html'>TUTORIAL</A></B></TD>\n";
print "<TD><B><A HREF='mailto:jvanheld\@bigre.ulb.ac.be'>MAIL</A></B></TD>\n";
print "</TR></TABLE></UL></UL>\n";

print "</FONT>\n";

print $query->end_html;

exit(0);


