
def download_go(args):
    
    import sys
    try:
        from urllib.request import urlopen
    except ImportError:
        from urllib import urlopen

    url = "http://www.geneontology.org/ontology/obo_format_1_2/gene_ontology_ext.obo"

    try:
        response = urlopen(url)
        data = response.read()
    except:
        print("Can't reach server at : %s" % url)
        print(sys.exc_info()[1])
        
    str_data = data.decode('utf-8')

    if args.outFile is None:
        sys.stdout.write(str_data)
    else:    
        with open(args.outFile.name, "w") as f:
            f.write(str_data)



def ancestor(args):
    import goatools
    import os
    from collections import defaultdict
    
    ## a two-way dictionnary (hash of hash)
    ## This ensures there will be no duplicates in output
    
    gene2Term = defaultdict(dict)
        
    ## Recursively unlist
    ## a list of lists of unknow depth
    
    
    def unlist(l):

        if any([type(x) == list for x in l]):
            l = sum(l, [])
            return(unlist(l))
        else:
            return set([t.id for t in l])
        
            
    
    ## Need to change dir as obo_parser.GODag don't handle path.

    oldPath     = os.getcwd()
    newPath     = os.path.dirname(args.goFile.name)
    fileName    = os.path.basename(args.goFile.name)
     
    os.chdir(newPath)
    
    ## create a GODag object 
    ## that contains the GO tree
    go = goatools.obo_parser.GODag(fileName)

    ## read all the gene to GO term relations
    
    for line in args.inFile:
        line    = line.rstrip("\r")
        line    = line.rstrip("\n")
        (gn,term)   = line.split("\t")
        
        # get ancestor
        ac = go.paths_to_top(term)
            
        # recursively unlist...
        
        ac = unlist(ac)
        
        for t in ac:
            gene2Term[gn][t] = 1
            
    ## go through
    for g  in gene2Term:
        for t in gene2Term[g]:
            if args.outFile is not None:
                args.outFile.write(g+"\t"+t+"\n")
            else :
                print g+"\t"+t



def parse_go():
    print("function parse_go")


def get_annotations(org_name):
    print("function get_annotations")


def expand(org_name):
    print("function expand")


def enrichment():
    print("function enrichment")