package MyTypes::GeneInfoRequest;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(0);

sub get_xmlns { 'urn:RSATWS' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %output_of :ATTR(:get<output>);
my %organism_of :ATTR(:get<organism>);
my %query_of :ATTR(:get<query>);
my %full_of :ATTR(:get<full>);
my %noquery_of :ATTR(:get<noquery>);
my %descr_of :ATTR(:get<descr>);
my %feattype_of :ATTR(:get<feattype>);
my %all_genes_of :ATTR(:get<all_genes>);

__PACKAGE__->_factory(
    [ qw(        output
        organism
        query
        full
        noquery
        descr
        feattype
        all_genes

    ) ],
    {
        'output' => \%output_of,
        'organism' => \%organism_of,
        'query' => \%query_of,
        'full' => \%full_of,
        'noquery' => \%noquery_of,
        'descr' => \%descr_of,
        'feattype' => \%feattype_of,
        'all_genes' => \%all_genes_of,
    },
    {
        'output' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'organism' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'query' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'full' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'noquery' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'descr' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'feattype' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'all_genes' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
    },
    {

        'output' => 'output',
        'organism' => 'organism',
        'query' => 'query',
        'full' => 'full',
        'noquery' => 'noquery',
        'descr' => 'descr',
        'feattype' => 'feattype',
        'all_genes' => 'all_genes',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

MyTypes::GeneInfoRequest

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
GeneInfoRequest from the namespace urn:RSATWS.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * output


=item * organism


=item * query


=item * full


=item * noquery


=item * descr


=item * feattype


=item * all_genes




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # MyTypes::GeneInfoRequest
   output =>  $some_value, # string
   organism =>  $some_value, # string
   query =>  $some_value, # string
   full =>  $some_value, # int
   noquery =>  $some_value, # int
   descr =>  $some_value, # int
   feattype =>  $some_value, # string
   all_genes =>  $some_value, # int
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

