package MyTypes::AlterGraphRequest;
use strict;
use warnings;


our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %output_of :ATTR(:get<output>);
my %informat_of :ATTR(:get<informat>);
my %outformat_of :ATTR(:get<outformat>);
my %inputgraph_of :ATTR(:get<inputgraph>);
my %wcol_of :ATTR(:get<wcol>);
my %scol_of :ATTR(:get<scol>);
my %tcol_of :ATTR(:get<tcol>);
my %directed_of :ATTR(:get<directed>);
my %duplicate_of :ATTR(:get<duplicate>);
my %self_of :ATTR(:get<self>);
my %target_of :ATTR(:get<target>);
my %add_nodes_of :ATTR(:get<add_nodes>);
my %rm_nodes_of :ATTR(:get<rm_nodes>);
my %add_edges_of :ATTR(:get<add_edges>);
my %rm_edges_of :ATTR(:get<rm_edges>);

__PACKAGE__->_factory(
    [ qw(        output
        informat
        outformat
        inputgraph
        wcol
        scol
        tcol
        directed
        duplicate
        self
        target
        add_nodes
        rm_nodes
        add_edges
        rm_edges

    ) ],
    {
        'output' => \%output_of,
        'informat' => \%informat_of,
        'outformat' => \%outformat_of,
        'inputgraph' => \%inputgraph_of,
        'wcol' => \%wcol_of,
        'scol' => \%scol_of,
        'tcol' => \%tcol_of,
        'directed' => \%directed_of,
        'duplicate' => \%duplicate_of,
        'self' => \%self_of,
        'target' => \%target_of,
        'add_nodes' => \%add_nodes_of,
        'rm_nodes' => \%rm_nodes_of,
        'add_edges' => \%add_edges_of,
        'rm_edges' => \%rm_edges_of,
    },
    {
        'output' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'informat' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'outformat' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'inputgraph' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'wcol' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'scol' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'tcol' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'directed' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'duplicate' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'self' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'target' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'add_nodes' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'rm_nodes' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'add_edges' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'rm_edges' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
    },
    {

        'output' => 'output',
        'informat' => 'informat',
        'outformat' => 'outformat',
        'inputgraph' => 'inputgraph',
        'wcol' => 'wcol',
        'scol' => 'scol',
        'tcol' => 'tcol',
        'directed' => 'directed',
        'duplicate' => 'duplicate',
        'self' => 'self',
        'target' => 'target',
        'add_nodes' => 'add_nodes',
        'rm_nodes' => 'rm_nodes',
        'add_edges' => 'add_edges',
        'rm_edges' => 'rm_edges',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

MyTypes::AlterGraphRequest

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
AlterGraphRequest from the namespace urn:RSATWS.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * output


=item * informat


=item * outformat


=item * inputgraph


=item * wcol


=item * scol


=item * tcol


=item * directed


=item * duplicate


=item * self


=item * target


=item * add_nodes


=item * rm_nodes


=item * add_edges


=item * rm_edges




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # MyTypes::AlterGraphRequest
   output =>  $some_value, # string
   informat =>  $some_value, # string
   outformat =>  $some_value, # string
   inputgraph =>  $some_value, # string
   wcol =>  $some_value, # int
   scol =>  $some_value, # int
   tcol =>  $some_value, # int
   directed =>  $some_value, # int
   duplicate =>  $some_value, # int
   self =>  $some_value, # int
   target =>  $some_value, # string
   add_nodes =>  $some_value, # string
   rm_nodes =>  $some_value, # string
   add_edges =>  $some_value, # string
   rm_edges =>  $some_value, # string
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

