package MyTypes::MCLRequest;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(0);

sub get_xmlns { 'urn:RSATWS' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %output_of :ATTR(:get<output>);
my %inputgraph_of :ATTR(:get<inputgraph>);
my %inflation_of :ATTR(:get<inflation>);

__PACKAGE__->_factory(
    [ qw(        output
        inputgraph
        inflation

    ) ],
    {
        'output' => \%output_of,
        'inputgraph' => \%inputgraph_of,
        'inflation' => \%inflation_of,
    },
    {
        'output' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'inputgraph' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'inflation' => 'SOAP::WSDL::XSD::Typelib::Builtin::float',
    },
    {

        'output' => 'output',
        'inputgraph' => 'inputgraph',
        'inflation' => 'inflation',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

MyTypes::MCLRequest

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
MCLRequest from the namespace urn:RSATWS.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * output


=item * inputgraph


=item * inflation




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # MyTypes::MCLRequest
   output =>  $some_value, # string
   inputgraph =>  $some_value, # string
   inflation =>  $some_value, # float
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

