################################################################
## Prepare a release version of rsa-tools
## distribution.mk makefile
## Usage: make -f distribution.mk

include ${RSAT}/makefiles/util.mk
MAKEFILE=${RSAT}/makefiles/distribution.mk
MAKE = make -sk -f ${MAKEFILE}

## Archive file
DATE=`date +%Y-%m-%d`
ARCHIVE_PREFIX=rsat_${DATE}
ARCHIVE_PREFIX_METAB=metabolic-tools_${DATE}
ARCHIVE=rsat/${ARCHIVE_PREFIX}

## Archive with tar
#TAR_EXCLUDE=-X CVS '*~' 
TAR_EXCLUDE=--exclude .git \
	--exclude CVS \
	--exclude '*~~' \
	--exclude tmp \
	--exclude data \
	--exclude logs \
	--exclude doc/manuals/*.toc \
	--exclude doc/manuals/*.idx \
	--exclude doc/manuals/*.aux \
	--exclude doc/manuals/*.log \
	--exclude doc/manuals/*.out \
	--exclude doc/manuals/*.pdf \
	--exclude course \
	--exclude eccb_2014_tutorial \
	--exclude '*.o' \
	--exclude peak-footprints \
	--exclude floydwarshall \
	--exclude kwalks \
	--exclude REA \
	--exclude REA-* \
	--exclude purgatory \
	--exclude Rpackages
TAR_CREATE =tar ${TAR_EXCLUDE} -cpf ${ARCHIVE}.tar rsat/*_default.*
TAR =tar ${TAR_EXCLUDE} -rpf ${ARCHIVE}.tar 

################################################################
## All the tasks for publishing the new version
all: clean_emacs_bk tar_archive clean_distrib_site publish

## List parameters
#PUB_SERVER=rsat.ulb.ac.be
PUB_SERVER=pedagogix-tagc.univ-mrs.fr
PUB_LOGIN=rsat
SSH_OPT=
PUB_FORMAT=tar.gz
PUB_DIR=/data/rsat_distribution
DISTRIB_URL=http://${PUB_SERVER}/download_rsat/
list_param:
	@echo "RSAT distribution parameters"
	@echo "	ARCHIVE			${ARCHIVE}"
	@echo "	PUB_LOGIN		${PUB_LOGIN}"
	@echo "	PUB_SERVER		${PUB_SERVER}"
	@echo "	PUB_DIR			${PUB_DIR}"
	@echo "	DISTRIB_URL		${DISTRIB_URL}"
	@echo "	PUB_TARGET_MANUALS	${PUB_TARGET_MANUALS}"

################################################################
## Generate the Manuals and tutorials
manuals:
	(cd doc/manuals; make fullclean; make install_guide; make rsat_tutorial; make neat_tutorial; make web_server_guide; make tex_clean)
	rsync -rtupvl -e "ssh ${SSH_OPT}" doc/manuals/*.pdf public_html/distrib

## Install manuals on the RSAT Web server
PUB_TARGET_MANUALS=${PUB_LOGIN}@${PUB_SERVER}:rsat/public_html/distrib/
publish_manuals:
	echo "Publishing manuals on server ${PUB_TARGET_MANUALS}"
	rsync -ruptvl -e 'ssh ${SSH_OPT}' doc/manuals/*.pdf ${PUB_TARGET_MANUALS}

################################################################
## Clean temporary backup files generated by emacs
CLEAN_DIRS=perl-scripts makefiles R-scripts doc ws_clients public_html/tutorials public_html/web_services 
clean_emacs_bk:
	@for dir in ${CLEAN_DIRS}; do \
		echo "	Cleaning directory" $${dir} ; \
		find $${dir} -name '*~' -exec rm {} \; ; \
		find $${dir} -name '.#*' -exec rm {} \; ; \
		find $${dir} -name '#*' -exec rm {} \; ; \
	done
	@echo "	Cleaning directory public_html"
	@rm -f public_html/*~ public_html/.#* public_html/#*
	@rm -f *~ .#* #*

################################################################
## Create tar and zip archives of the whole distribution
POST_CMD=
TAR_ROOT=`dirname ${RSAT}`
DISTRIB_FILES=rsat/00_README.txt			\
	rsat/perl-scripts			\
	rsat/R-scripts 				\
	rsat/makefiles				\
	rsat/RSAT_config_default.props		\
	rsat/RSAT_config_default.mk		\
	rsat/RSAT_config_default.bashrc		\
	rsat/rsat_apache_default.conf		\
	rsat/doc/manuals			\
	rsat/python-scripts 			\
	rsat/contrib/count-words  		\
	rsat/contrib/compare-matrices-quick  	\
	rsat/contrib/info-gibbs			\
	rsat/contrib/matrix-scan-quick  	\
	rsat/ws_clients		  		\
	rsat/public_html

PATHWAY_FILES = \
	rsat/contrib/floydwarshall		\
	rsat/contrib/REA			\
	rsat/contrib/kwalks

DISTRIB_FILES_METAB=rsat/java		\
	rsat/contrib/REA		\
	rsat/contrib/kwalks

_create_tar_archive:
	@echo ${TAR_CREATE} 
	(cd ${TAR_ROOT}; ${TAR_CREATE})

FILE=rsat/perl-scripts
_add_one_file:
	@echo ${ARCHIVE_CMD} ${FILE} ${POST_CMD}
	${ARCHIVE_CMD} ${FILE}  ${POST_CMD}

_fill_archive:
	(cd ${TAR_ROOT};				\
	for f in ${DISTRIB_FILES}; do			\
		${MAKE} _add_one_file FILE=$${f};	\
	done)
	@echo "Archive created	${ARCHIVE}"

## Create an archive with RSAT/NeAT tools
tar_archive:
	@echo
	@echo "Creating tar archive with RSAT/NeAT tools"
	${MAKE} _create_tar_archive
	${MAKE} _fill_archive ARCHIVE_CMD='${TAR}' POST_CMD=''
	(cd ${TAR_ROOT}; gzip -f ${ARCHIVE}.tar)
	@echo
	@echo "Archive"
	@echo "	${TAR_ROOT}/${ARCHIVE}.tar.gz"

## Create an archive with the metabolic tools (since the java files occupy 80Mb, we distribute them separately
tar_archive_metab:
	${MAKE} tar_archive ARCHIVE_PREFIX=${ARCHIVE_PREFIX_METAB} DISTRIB_FILES="${DISTRIB_FILES_METAB}"

## Archive with zip
# ZIP_EXCLUDE=-x CVS '*~' tmp data logs
# ZIP =zip -ry ${ARCHIVE}.zip 
# zip_archive:
# 	${MAKE} _fill_archive ARCHIVE_CMD='${ZIP}' POST_CMD='${ZIP_EXCLUDE}'


ls_distrib:
	ssh ${SSH_OPT} ${PUB_LOGIN}@${PUB_SERVER} "ls -ltra ${PUB_DIR}/"

clean_distrib_site:
	@echo
	@echo "Moving previous archives from the public server ${PUB_LOGIN}@${PUB_SERVER} to ${PUB_DIR}/previous_versions"
	ssh ${SSH_OPT} ${PUB_LOGIN}@${PUB_SERVER} "mv -f ${PUB_DIR}/rsat_*.tar.gz ${PUB_DIR}/previous_versions/"

################################################################
## Publish the tar archive of the whole distribution
publish:
	@echo
	@echo "Synchronizing RSAT archive ${ARCHIVE_PREFIX}.${PUB_FORMAT} to server ${PUB_LOGIN}@${PUB_SERVER}:${PUB_DIR}"
	@echo
	rsync -ruptvl -e "ssh ${SSH_OPT}" ${ARCHIVE_PREFIX}.${PUB_FORMAT} ${PUB_LOGIN}@${PUB_SERVER}:${PUB_DIR}/

publish_metab:
	@${MAKE} publish ARCHIVE_PREFIX=${ARCHIVE_PREFIX_METAB}

## Open the distribution Web site
BROWSER=firefox
web:
	 open -a ${BROWSER} ${DISTRIB_URL}

################################################################
## Make a tar archive of the ws clients
TAR_WSCLIENTS=public_html/web_services/RSATWS_clients.tar.gz
tar_wsclients:
	@rm -f ${TAR_WSCLIENTS}
	tar \
	--exclude CVS  \
	--exclude '*~' \
	--exclude '*.DS_Store' -cpzf ${TAR_WSCLIENTS} ws_clients
	@echo ${TAR_WSCLIENTS}

publish_tar_wsclients:
	rsync -ruptvl -e "ssh ${SSH_OPT}" ${TAR_WSCLIENTS} ${PUB_LOGIN}@${PUB_SERVER}:rsat/public_html/web_services/

