#!/usr/bin/perl
# the first line of the script must tell us which language interpreter to use,
# in this case its perl

use strict;

# import the modules we need for this test; XML::Compile is included on the server
# by default.
use XML::Compile::WSDL11;
use XML::Compile::Transport::SOAPHTTP;

eval
{
    # Retriving and processing the WSDL
    my $wsdl  = XML::LibXML->new->parse_file('http://rsat.bigre.ulb.ac.be/rsat/web_services/RSATWS.wsdl');
    my $proxy = XML::Compile::WSDL11->new($wsdl);
    
    # Generating a request message based on the WSDL
    my $getSequence = $proxy->compileClient('oligo_analysis');
    
    # Defining a few parameters
    my $sequence = '>NP_009651.1    PHO5; upstream from -800 to -1; size: 800; location: NC_001134.7 430946 431745 R; upstream neighbou
r: NP_009652.1 (distance: 1084)
TTTTACACATCGGACTGATAAGTTACTACTGCACATTGGCATTAGCTAGGAGGGCATCCAAGTAATAATTGCGAGAAACGTGACCCAACTTTGTTGTAGGTCCGCTCCTTCTAATAATCGCTTGTATCTCT
ACATATGTTCTATTTACTGACCGAAAGTAGCTCGCTACAATAATAATGTTGACCTGATGTCAGTCCCCACGCTAATAGCGGCGTGTCGCACGCTCTCTTTACAGGACGCCGGAGACCGGCATTACAAGGAT
CCGAAAGTTGTATTCAACAAGAATGCGCAAATATGTCAACGTATTTGGAAGTCATCTTATGTGCGCTGCTTTAATGTTTTCTCATGTAAGCGGACGTCGTCTATAAACTTCAAACGAAGGTAAAAGGTTCA
TAGCGCTTTTTCTTTGTCTGCACAAAGAAATATATATTAAATTAGCACGTTTTCGCATAGAACGCAACTGCACAATGCCAAAAAAAGTAAAAGTGATTAAAAGAGTTAATTGAATAGGCAATCTCTAAATG
AATCGATACAACCTTGGCACTCACACGTGGGACTAGCACAGACTAAATTTATGATTCTGGTCCCTGTTTTCGAAGAGATCGCACATGCCAAATTATCAAATTGGTCACCTTACTTGGCAAGGCATATACCC
ATTTGGGATAAGGGTAAACATCTTTGAATTGTCGAAATGAAACGTATATAAGCGCTGATGTTTTGCTAAGTCGAGGTTAGTATGGCTTCATCTCTCATGAGAATAAGAACAACAACAAATAGAGCAAGCAA
ATTCGAGATTACCA
>NP_010769.1    PHO8; upstream from -180 to -1; size: 180; location: NC_001136.8 1420243 1420422 R; upstream neighbour: NP_010770.1
 (distance: 180)
CAGCATTGACGATAGCGATAAGCTTCGCGCGTAGAGGAAAAGTAAAGGGATTTTAGTATATAAAGAAAGAAGTGTATCTAAACGTTTATATTTTTTCGTGCTCCACATTTTGCCAGCAAGTGGCTACATAA
ACATTTACATATCAGCATACGGGACATTATTTGAACGCGCATTAGCAGC
>NP_009434.1    PHO11; upstream from -800 to -1; size: 800; location: NC_001133.6 224651 225450 D; upstream neighbour: NP_009431.1 
(distance: 2568)
GCAGCCTCTACCATGTTGCAAGTGCGAACCATACTGTGGCCACATAGATTACAAAAAAAGTCCAGGATATCTTGCAAACCTAGCTTGTTTTGTAAACGACATTGAAAAAAGCGTATTAAGGTGAAACAATC
AAGATTATCTATGCCGATGAAAAATGAAAGGTATGATTTCTGCCACAAATATATAGTAGTTATTTTATACATCAAGATGAGAAAATAAAGGGATTTTTTCGTTCTTTTATCATTTTCTCTTTCTCACTTCC
GACTACTTCTTATATCTACTTTCATCGTTTCATTCATCGTGGGTGTCTAATAAAGTTTTAATGACAGAGATAACCTTGATAAGCTTTTTCTTATACGCTGTGTCACGTATTTATTAAATTACCACGTTTTC
GCATAACATTCTGTAGTTCATGTGTACTAAAAAAAAAAAAAAAAAAGAAATAGGAAGGAAAGAGTAAAAAGTTAATAGAAAACAGAACACATCCCTAAACGAAGCCGCACAATCTTGGCGTTCACACGTGG
GTTTAAAAAGGCAAATTACACAGAATTTCAGACCCTGTTTACCGGAGAGATTCCATATTCCGCACGTCACATTGCCAAATTGGTCATCTCACCAGATATGTTATACCCGTTTTGGAATGAGCATAAACAGC
GTCGAATTGCCAAGTAAAACGTATATAAGCTCTTACATTTCGATAGATTCAAGCTCAGTTTCGCCTTGGTTGTAAAGTAGGAAGAAGAAGAAGAAGAAGAGGAACAACAACAGCAAAGAGAGCAAGAACAT
CATCAGAAATACCA
>NP_011749.1    PHO81; upstream from -800 to -1; size: 800; location: NC_001139.7 958214 959013 R; upstream neighbour: NP_011750.1 
(distance: 1694)
AAACGAGCATGAGGGTTACAAAGAACTTCCGTTTCAAAAATGAATATAATCGTACGTTTACCTTGTGGCAGCACTAGCTAACGCTACGTGGAATGAACGTACCGTGCCCTATTATTCTTGCTTGTGCTATC
TCAAGAATTGCATTTTGTAATAACAACTGCATGGGAAAAATTATATAGATTTTCTACTATTATGTCCGCCTAAGTCAGTTAACCATCTTTATCACAAAATATACAATTAACCAACTACTTAATCAATTCGG
TTATATTGCTTAGTATATACGTCTTTGGCACGCGATTGAAACGCGCTAATTGCATCAGCCTATCTTTCTATGCAAGAATGCAAGAAAAATTGATGTGATGTGCCTTATCACAATTCATTACCTCCTATTTC
CTCTGCAGCAACAAGTTTCCTTGATTATAAAGGTCTTTAGCGTGAGAGGTACAGGTGTTATGGCACGTGCGAATAAGGGCAGAAATTAATCAAATTTATCAACTATTTGGCGATGGCTCGAGACAGGTATA
GAACCACTACTAGGTGATATTGAGGCTTTTGTACAATTTATAGCAAGTTTTTGAGAGTCCCTTCAAGTTTGTTACATAATCTTCTTTGTGCAACGTACAAGAGCAAAGTAGAAAAATTTGGTTTTTATTTT
TTTAAGCAACATCAGCTGCACTAGTTGAGCTTTTGACAAGACATACTGCTCAAAAAATCTTCATAACATTATTTTTCGGTTCCACAGTGATTGAGCTTTTTGAGAGAATAACCCTTTGGAGGCAACATAGA
TAGATAAACGTGCA
>NP_013583.1    PHO84; upstream from -800 to -1; size: 800; location: NC_001145.2 25802 26601 R; upstream neighbour: NP_013585.1 (d
istance: 1128)
AAAAAAAAAGATTCAATAAAAAAAGAAATGAGATCAAAAAAAAAAAAAATTAAAAAAAAAAAGAAACTAATTTATCAGCCGCTCGTTTATCAACCGTTATTACCAAATTATGAATAAAAAAACCATATTAT
TATGAAAAGACACAACCGGAAGGGGAGATCACAGACCTTGACCAAGAAAACATGCCAAGAAATGACAGCAATCAGTATTACGCACGTTGGTGCTGTTATAGGCGCCCTATACGTGCAGCATTTGCTCGTAA
GGGCCCTTTCAACTCATCTAGCGGCTATGAAGAAAATGTTGCCCGGCTGAAAAACACCCGTTCCTCTCACTGCCGCACCGCCCGATGCCAATTTAATAGTTCCACGTGGACGTGTTATTTCCAGCACGTGG
GGCGGAAATTAGCGACGGCAATTGATTATGGTTCGCCGCAGTCCATCGAAATCAGTGAGATCGGTGCAGTTATGCACCAAATGTCGTGTGAAAGGCTTTCCTTATCCCTCTTCTCCCGTTTTGCCTGCTTA
TTAGCTAGATTAAAAACGTGCGTATTACTCATTAATTAACCGACCTCATCTATGAGCTAATTATTATTCCTTTTTGGCAGCATGATGCAACCACATTGCACACCGGTAATGCCAACTTAGATCCACTTACT
ATTGTGGCTCGTATACGTATATATATAAGCTCATCCTCATCTCTTGTATAAAGTAAAGTTCTAAGTTCACTTCTAAATTTTATCTTTCCTCATCTCGTAGATCACCAGGGCACACAACAAACAAAACTCCA
CGAATACAATCCAA';

#my $verbosity = 1;
my $format = 'fasta';  ## The format of input sequences
my $length = 6;  ## Length of patterns to be discovered
my $organism = 'Saccharomyces_cerevisiae';  ## Name of the query organism
my $background = 'upstream-noorf';  ## Type of background used
my $stats = 'occ,proba,rank';  ## Returned statistics
my $noov = 1;  ## Do not allow overlapping patterns
my $str = 2;  ## Search on both strands
my $sort = 1;  ## Sort the result according to score when value = 1
my @lth = ('occ_sig 0');
my @uth = ('rank 3');

my %args = (
            'sequence' => $sequence, 
            'format' => $format,
            'length' => $length,
            'organism' => $organism, 
            'background' => $background,
            'stats' => $stats,
            'noov' => $noov,
            'str' => $str,
            'sort' => $sort,
            'lth' => \@lth,
            'uth' => \@uth
           );

    # Calling the service and getting the response
    my $answer = $getSequence->( request => {%args});

    # If the response arrived, look for a specific pattern
    # If the pattern is present, return 0 because the test passed.
    # If the result is something else, return 2 to indicate a warning.
    # If no answer has arrived, return 1 to indicate the test failed.
    if ( defined $answer ) {
#	print "Result : ".$answer->{output}->{response}->{client}."\n";
	if ($answer->{output}->{response}->{client} =~ 'tgccaa'){
	    print "Passed\n";
	    exit 0;
	} else {
	    print "Unexpected data\n";
	    exit 2;
	}
    } else {    
	print "Failed\n";
	exit 1;
    }
};

if ($@)
{
    print "Caught an exception\n";
    print $@."\n";
    exit 1;
}
