
package MyElements::convert_matrix;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'urn:RSATWS' }

__PACKAGE__->__set_name('convert_matrix');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();

use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    SOAP::WSDL::XSD::Typelib::ComplexType
);

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %request_of :ATTR(:get<request>);

__PACKAGE__->_factory(
    [ qw(        request

    ) ],
    {
        'request' => \%request_of,
    },
    {
        'request' => 'MyTypes::ConvertMatrixRequest',
    },
    {

        'request' => 'request',
    }
);

} # end BLOCK






} # end of BLOCK



1;


=pod

=head1 NAME

MyElements::convert_matrix

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
convert_matrix from the namespace urn:RSATWS.





=head1 METHODS

=head2 new

 my $element = MyElements::convert_matrix->new($data);

Constructor. The following data structure may be passed to new():

 {
   request =>  { # MyTypes::ConvertMatrixRequest
     output =>  $some_value, # string
     matrix =>  $some_value, # string
     background_format =>  $some_value, # string
     background_pseudo =>  $some_value, # float
     from =>  $some_value, # string
     to =>  $some_value, # string
     return =>  $some_value, # string
     sort =>  $some_value, # string
     top =>  $some_value, # int
     pseudo =>  $some_value, # float
     equi_pseudo =>  $some_value, # int
     base =>  $some_value, # string
     decimals =>  $some_value, # int
     perm =>  $some_value, # int
     max_profile =>  $some_value, # int
     rc =>  $some_value, # int
   },
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

