
package MyElements::parse_psi_xml;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'urn:RSATWS' }

__PACKAGE__->__set_name('parse_psi_xml');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();

use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    SOAP::WSDL::XSD::Typelib::ComplexType
);

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %request_of :ATTR(:get<request>);

__PACKAGE__->_factory(
    [ qw(        request

    ) ],
    {
        'request' => \%request_of,
    },
    {
        'request' => 'MyTypes::parsepsixmlRequest',
    },
    {

        'request' => 'request',
    }
);

} # end BLOCK






} # end of BLOCK



1;


=pod

=head1 NAME

MyElements::parse_psi_xml

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
parse_psi_xml from the namespace urn:RSATWS.





=head1 METHODS

=head2 new

 my $element = MyElements::parse_psi_xml->new($data);

Constructor. The following data structure may be passed to new():

 {
   request =>  { # MyTypes::parsepsixmlRequest
     output =>  $some_value, # string
     inputfile =>  $some_value, # string
     channels =>  $some_value, # string
     interactor_type =>  $some_value, # string
     uth =>  $some_value, # float
     lth =>  $some_value, # float
   },
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

