
package MyElements::retrieve_ensembl_seq;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'urn:RSATWS' }

__PACKAGE__->__set_name('retrieve_ensembl_seq');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();

use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    SOAP::WSDL::XSD::Typelib::ComplexType
);

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %request_of :ATTR(:get<request>);

__PACKAGE__->_factory(
    [ qw(        request

    ) ],
    {
        'request' => \%request_of,
    },
    {
        'request' => 'MyTypes::RetrieveEnsemblSequenceRequest',
    },
    {

        'request' => 'request',
    }
);

} # end BLOCK






} # end of BLOCK



1;


=pod

=head1 NAME

MyElements::retrieve_ensembl_seq

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
retrieve_ensembl_seq from the namespace urn:RSATWS.





=head1 METHODS

=head2 new

 my $element = MyElements::retrieve_ensembl_seq->new($data);

Constructor. The following data structure may be passed to new():

 {
   request =>  { # MyTypes::RetrieveEnsemblSequenceRequest
     output =>  $some_value, # string
     organism =>  $some_value, # string
     ensembl_host =>  $some_value, # string
     db_name =>  $some_value, # string
     query =>  $some_value, # string
     tmp_infile =>  $some_value, # string
     all =>  $some_value, # int
     noorf =>  $some_value, # int
     nogene =>  $some_value, # int
     from =>  $some_value, # int
     to =>  $some_value, # int
     feattype =>  $some_value, # string
     type =>  $some_value, # string
     chromosome =>  $some_value, # string
     left =>  $some_value, # int
     right =>  $some_value, # int
     strand =>  $some_value, # int
     features =>  $some_value, # string
     feat_format =>  $some_value, # string
     mask_coding =>  $some_value, # int
     repeat =>  $some_value, # int
     all_transcripts =>  $some_value, # int
     unique_sequences =>  $some_value, # int
     first_intron =>  $some_value, # int
     non_coding =>  $some_value, # int
     utr =>  $some_value, # string
     line_width =>  $some_value, # int
     ortho =>  $some_value, # int
     taxon =>  $some_value, # string
     homology_type =>  $some_value, # string
     header_organism =>  $some_value, # string
   },
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

