package MyTypes::ConvertClassesRequest;
use strict;
use warnings;


our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %output_of :ATTR(:get<output>);
my %informat_of :ATTR(:get<informat>);
my %outformat_of :ATTR(:get<outformat>);
my %member_col_of :ATTR(:get<member_col>);
my %class_col_of :ATTR(:get<class_col>);
my %score_col_of :ATTR(:get<score_col>);
my %min_score_of :ATTR(:get<min_score>);
my %inputclasses_of :ATTR(:get<inputclasses>);
my %names_of :ATTR(:get<names>);

__PACKAGE__->_factory(
    [ qw(        output
        informat
        outformat
        member_col
        class_col
        score_col
        min_score
        inputclasses
        names

    ) ],
    {
        'output' => \%output_of,
        'informat' => \%informat_of,
        'outformat' => \%outformat_of,
        'member_col' => \%member_col_of,
        'class_col' => \%class_col_of,
        'score_col' => \%score_col_of,
        'min_score' => \%min_score_of,
        'inputclasses' => \%inputclasses_of,
        'names' => \%names_of,
    },
    {
        'output' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'informat' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'outformat' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'member_col' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'class_col' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'score_col' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'min_score' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'inputclasses' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'names' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
    },
    {

        'output' => 'output',
        'informat' => 'informat',
        'outformat' => 'outformat',
        'member_col' => 'member_col',
        'class_col' => 'class_col',
        'score_col' => 'score_col',
        'min_score' => 'min_score',
        'inputclasses' => 'inputclasses',
        'names' => 'names',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

MyTypes::ConvertClassesRequest

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
ConvertClassesRequest from the namespace urn:RSATWS.

Parameters for the operation convert-classes.




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * output


=item * informat


=item * outformat


=item * member_col


=item * class_col


=item * score_col


=item * min_score


=item * inputclasses


=item * names




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # MyTypes::ConvertClassesRequest
   output =>  $some_value, # string
   informat =>  $some_value, # string
   outformat =>  $some_value, # string
   member_col =>  $some_value, # string
   class_col =>  $some_value, # string
   score_col =>  $some_value, # int
   min_score =>  $some_value, # string
   inputclasses =>  $some_value, # string
   names =>  $some_value, # string
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

