package MyTypes::GraphCliquesRequest;
use strict;
use warnings;


our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %output_of :ATTR(:get<output>);
my %informat_of :ATTR(:get<informat>);
my %inputgraph_of :ATTR(:get<inputgraph>);
my %scol_of :ATTR(:get<scol>);
my %tcol_of :ATTR(:get<tcol>);
my %min_size_of :ATTR(:get<min_size>);

__PACKAGE__->_factory(
    [ qw(        output
        informat
        inputgraph
        scol
        tcol
        min_size

    ) ],
    {
        'output' => \%output_of,
        'informat' => \%informat_of,
        'inputgraph' => \%inputgraph_of,
        'scol' => \%scol_of,
        'tcol' => \%tcol_of,
        'min_size' => \%min_size_of,
    },
    {
        'output' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'informat' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'inputgraph' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'scol' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'tcol' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'min_size' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
    },
    {

        'output' => 'output',
        'informat' => 'informat',
        'inputgraph' => 'inputgraph',
        'scol' => 'scol',
        'tcol' => 'tcol',
        'min_size' => 'min_size',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

MyTypes::GraphCliquesRequest

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
GraphCliquesRequest from the namespace urn:RSATWS.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * output


=item * informat


=item * inputgraph


=item * scol


=item * tcol


=item * min_size




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # MyTypes::GraphCliquesRequest
   output =>  $some_value, # string
   informat =>  $some_value, # string
   inputgraph =>  $some_value, # string
   scol =>  $some_value, # int
   tcol =>  $some_value, # int
   min_size =>  $some_value, # int
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

