#!/usr/bin/perl

# perl pathfinder client

use strict;

# import the modules we need for this test; XML::Compile is included on the server
# by default.
use XML::Compile::SOAP11;
use XML::Compile::WSDL11;
use XML::Compile::Transport::SOAPHTTP;

# Retrieving and processing the WSDL
my $wsdl  = XML::LibXML->new->parse_file('http://wwwsup.scmbb.ulb.ac.be/be.ac.ulb.bigre.graphtools.server/wsdl/GraphAlgorithmsNeAT.wsdl');
my $proxy = XML::Compile::WSDL11->new($wsdl);
    
# Generating a request message based on the WSDL
my $pathfinding = $proxy->compileClient('pathfinding');
    
# Calling the service and getting the response
my $source = "C00049";
my $target = "C00047";
my $graphId = "Pathfinder_tmpGraph_c4b592c7-23f7-4080-851a-e6d870cc7cf9.tab";
my $exclusionAttr = "ExclusionAttribute";

my $answer = $pathfinding->( request => {source => $source, target => $target, nodesPresent => "", nodesAbsent => "", graphString => $graphId, tmpInGraphFile => "", inFormat => "tab", outFormat => "tab", directed => 0, metabolic => 1, weight => "con", exclusionAttr => $exclusionAttr, algorithm => "rea", rank => 1, maxWeight => 10000, maxLength => 10000, minLength => 1, attribs => "", outputType => "pathsTable", storeInputGraph => 0, returnType => "client"});

print "Result : ".$answer->{output}->{response}->{client}."\n";