#! /usr/bin/python

# Python pathfinder client
import os, sys, SOAPpy

source = "C00049"
target = "C00047"
networkId = "Pathfinder_tmpGraph_c4b592c7-23f7-4080-851a-e6d870cc7cf9.tab"
exclusionAttr = "ExclusionAttribute"

url = "http://wwwsup.scmbb.ulb.ac.be/be.ac.ulb.bigre.graphtools.server/wsdl/GraphAlgorithmsNeAT.wsdl"
namespace = 'urn:graphtools'

# configure server    
server = SOAPpy.WSDL.Proxy(url)

server.soapproxy.config.dumpSoapOutput = 0
server.soapproxy.config.dumpSoapInput = 0
server.soapproxy.config.debug = 0 
server.namespace = namespace
server.soapaction = 'urn:graphtools#pathfinding'
    
request = {'source' : source, 
          'target' : target,
          'graphString' : networkId,
          'exclusionAttr' : exclusionAttr,
           'inFormat' : "tab",
           'outFormat' : "tab",
           'weight' : "con",
           'algorithm' : "rea",
           'rank' : 1,
           'maxWeight' : 50000,
           'maxLength' : 50000,
           'minLength' : 1,
           'attribs' : "",
           'outputType' : "pathsTable",
           'returnType' : "client"}
    

res = server.pathfinding(request)

print res.command
print res.client