/***************************************************************************
 *                                                                         *
 *  array.h
 *  2D array class
 *   
 *  2008/02/29 
 *                                                                         *
 ***************************************************************************/
using namespace std;

#include <iostream>
#include <sstream>

#ifndef __ARRAY__
#define __ARRAY__

struct Array{
	double **data;
	int I;
	int J;
	Array(int dim1=0, int dim2=0, double val=0.0){
		I = dim1;
		J = dim2;
		data = NULL;
		if (I > 0 && J > 0)
			alloc(I, J, val);
	}

	void alloc(int dim1, int dim2, double val=0.0){
		I = dim1;
		J = dim2;
		if (I <= 0 || J <= 0)
			return;

		// alloc
		data = new double*[I];
		for (int i=0; i<I; i++)
			data[i] = new double[J];
		
		// init
		for (int i=0; i<I; i++){
			for (int j=0; j<J; j++)
				data[i][j] = val;
		}
	}

	Array(const Array& a){
		I = a.I;
		J = a.J;
		alloc(I, J);
		for(int i=0; i<I; i++){
			for(int j=0; j<J; j++)
				data[i][j] = a.data[i][j];
		}
	}

	Array& operator=(Array &a){
		I = a.I;
		J = a.J;
		alloc(I, J);
		for(int i=0; i<I; i++){
			for(int j=0; j<J; j++)
				data[i][j] = a.data[i][j];
		}
		return a;
	}

	~Array(){
		if (data != NULL){
			for (int i=0; i<I; i++)
				delete []data[i];
			delete []data;
		}
	}

	double * operator[](int i){
		return data[i];
	}

	double ** get_data(){
		return data;
	}
	
	string str(){
		stringstream buf;
		for(int i=0; i<I; i++){
			for(int j=0; j<J; j++)
				buf << data[i][j] << " ";
		buf << endl;
		}
		return buf.str();
	}
};


void print_matrix(double **data, int I, int J);


#endif

