/***************************************************************************
 *                                                                         *
 *  fasta.h
 *  simple fasta file reader
 *   
 *  2008/02/29 
 *                                                                         *
 ***************************************************************************/
using namespace std;

#include <iostream> 
#include <fstream>
#include <vector>
#include <string>

#ifndef __FASTA__
#define __FASTA__

#define ALPHABET_SIZE 4
#define ALPHABET "ACGT"

struct Sequence{
	int *data;
	int len;

	Sequence(int l= 0){
		len = l;
		if (len > 0)
			data = new int[len];
		else
			data = NULL;
	}
	
	~Sequence(){
		if (len > 0)
			delete []data;
	}

	Sequence &operator=(Sequence &s){
		len = s.len;
		data = new int[len];
		for(int i=0; i<len; i++){
			data[i] = s.data[i];
		}
		return s;
	}

	int size(){
		return len;
	}

	int  &operator[](int i){
		return data[i];
	}
};


struct Sequences{
	int len;
	Sequence *data;

	Sequences(int l=0){
		len = l;
		if (len > 0)
			data = new Sequence[len];
		else
			data = NULL;
	}

	~Sequences(){
		if (len > 0)
			delete []data;
	}

	Sequences &operator=(Sequences &s){
		len = s.len;
		data = new Sequence[len];
		for(int i=0; i<len; i++){
			data[i] = s.data[i];
		}
		return s;
	}

	int size(){
		return len;
	}

	Sequence &operator[](int i){
		return data[i];
	}
};

// sequences is an empty vector
int read_fasta(vector<string> &sequences, string filename, bool rc);
Sequences convert_sequences(vector<string> &raw_sequences);
double *compute_priori(Sequences &sequences);
//string reverse_complement(string s);


#endif
