/***************************************************************************
 *                                                                         *
 *  gibbs.h
 *  motif discovery gibbs sampler
 *   
 *  2008/02/29 
 *                                                                         *
 ***************************************************************************/
using namespace std;

#include <iostream> 
#include <vector>
#include <string>
#include <cmath>
#include <ctime> 
#include <set>

#include "fasta.h"
#include "array.h"
#include "markov.h"

#ifndef __GIBBS__
#define __GIBBS__

#define ALPHABET_SIZE 4
#define ALPHABET "ACGT"
#define PSEUDO 1.0

extern int VERBOSITY;
extern int UPDATE;
extern int SEED;
extern int VERSION;
extern char* COMMAND_LINE;

struct Site {
	int s;
	int p;
	
	Site(int seq=-1, int pos=-1){
		s = seq;
		p = pos;
	}

	bool operator==(Site o){
		return (s==o.s && p==o.p);
	}
};


struct Parameters {
    int l;       // motif length
	int iter;    // iterations
	int n;       // a motif is composed of w sites (or words)
	int nrun;    // run gibbs main loop n times
	double temperature;
    bool rc;
    int dmin;
    int motifs;
    int update;
};

void gibbs(vector<string> &raw_sequences, Sequences &sequences, Markov &markov, Parameters &params);

#endif
