################################################################
## Prepare a release of RSAT

include ${RSAT}/makefiles/util.mk
MAKEFILE=${RSAT}/makefiles/release_rsat.mk
MAKE = make -sk -f ${MAKEFILE}

## Archive file
DATE=`date +%Y-%m-%d`
ARCHIVE_PREFIX=rsat_${DATE}
ARCHIVE_PREFIX_METAB=metabolic-tools_${DATE}
ARCHIVE=rsat/${ARCHIVE_PREFIX}
ARCHIVE_PREFIX_SCRIPTS=${ARCHIVE_PREFIX}_install_scripts

## Archive with tar
#TAR_EXCLUDE=-X CVS '*~' 
TAR_EXCLUDE=--exclude .git \
	--exclude CVS \
	--exclude '*~~' \
	--exclude tmp \
	--exclude data \
	--exclude logs \
	--exclude doc/manuals/*.toc \
	--exclude doc/manuals/*.idx \
	--exclude doc/manuals/*.aux \
	--exclude doc/manuals/*.log \
	--exclude doc/manuals/*.out \
	--exclude course \
	--exclude eccb_2014_tutorial \
	--exclude '*.o' \
	--exclude peak-footprints \
	--exclude floydwarshall \
	--exclude kwalks \
	--exclude REA \
	--exclude REA-* \
	--exclude purgatory \
	--exclude .Rproj.user \
	--exclude '*.RData' \
	--exclude Rpackages
TAR_CREATE =tar ${TAR_EXCLUDE} -cpf ${ARCHIVE}.tar rsat/*_default.*
TAR =tar ${TAR_EXCLUDE} -rpf ${ARCHIVE}.tar 

################################################################
## All the tasks for publishing the new version
all: clean_emacs_bk tar_archive clean_release_site publish 

## List parameters
#PUB_SERVER=rsat.ulb.ac.be
PUB_SERVER=pedagogix-tagc.univ-mrs.fr
PUB_LOGIN=rsat
SSH_OPT=
PUB_FORMAT=tar.gz
PUB_DIR=/data/rsat_release
RELEASE_URL=http://${PUB_SERVER}/download_rsat/
list_param:
	@echo "RSAT release parameters"
	@echo "	ARCHIVE			${ARCHIVE}"
	@echo "	PUB_LOGIN		${PUB_LOGIN}"
	@echo "	PUB_SERVER		${PUB_SERVER}"
	@echo "	PUB_DIR			${PUB_DIR}"
	@echo "	RELEASE_URL		${RELEASE_URL}"
	@echo "	PUB_TARGET_MANUALS	${PUB_TARGET_MANUALS}"

################################################################
## Generate the Manuals and tutorials
manuals:
	(cd doc/manuals; make fullclean; make install_guide; make rsat_tutorial; make neat_tutorial; make web_server_guide; make tex_clean)
	rsync -rtupvl -e "ssh ${SSH_OPT}" doc/manuals/*.pdf public_html/release

## Install manuals on the RSAT Web server
PUB_TARGET_MANUALS=${PUB_LOGIN}@${PUB_SERVER}:rsat/public_html/release/
publish_manuals:
	echo "Publishing manuals on server ${PUB_TARGET_MANUALS}"
	rsync -ruptvl -e 'ssh ${SSH_OPT}' doc/manuals/*.pdf ${PUB_TARGET_MANUALS}

################################################################
## Clean temporary backup files generated by emacs
CLEAN_DIRS=perl-scripts makefiles R-scripts doc ws_clients public_html/tutorials public_html/web_services 
clean_emacs_bk:
	@for dir in ${CLEAN_DIRS}; do \
		echo "	Cleaning directory" $${dir} ; \
		find $${dir} -name '*~' -exec rm {} \; ; \
		find $${dir} -name '.#*' -exec rm {} \; ; \
		find $${dir} -name '#*' -exec rm {} \; ; \
	done
	@echo "	Cleaning directory public_html"
	@rm -f public_html/*~ public_html/.#* public_html/#*
	@rm -f *~ .#* #*

################################################################
## Create tar and zip archives of the whole release
POST_CMD=
TAR_ROOT=`dirname ${RSAT}`
RELEASE_FILES=rsat/00_README.txt		\
	rsat/INSTALL.md				\
	rsat/installer				\
	rsat/perl-scripts			\
	rsat/R-scripts/TFBMclust		\
	rsat/R-scripts/*.R			\
	rsat/R-scripts/util			\
	rsat/makefiles				\
	rsat/RSAT_config_default.props		\
	rsat/RSAT_config_default.mk		\
	rsat/RSAT_config_default.bashrc		\
	rsat/RSAT_config_default.conf		\
	rsat/RSAT_config_default_apache2.2.conf	\
	rsat/doc/manuals			\
	rsat/doc/howto				\
	rsat/python-scripts 			\
	rsat/contrib/count-words  		\
	rsat/contrib/compare-matrices-quick  	\
	rsat/contrib/info-gibbs			\
	rsat/contrib/matrix-scan-quick  	\
	rsat/ws_clients		  		\
	rsat/public_html

PATHWAY_FILES = \
	rsat/contrib/floydwarshall		\
	rsat/contrib/REA			\
	rsat/contrib/kwalks

RELEASE_FILES_METAB=rsat/java		\
	rsat/contrib/REA		\
	rsat/contrib/kwalks

#RELEASE_FILES_SCRIPTS=rsat/installer

_create_tar_archive:
	@echo ${TAR_CREATE} 
	(cd ${TAR_ROOT}; ${TAR_CREATE})



FILE=rsat/perl-scripts
_add_one_file:
	@echo ${ARCHIVE_CMD} ${FILE} ${POST_CMD}
	${ARCHIVE_CMD} ${FILE}  ${POST_CMD}

_fill_archive:
	(cd ${TAR_ROOT};				\
	for f in ${RELEASE_FILES}; do			\
		${MAKE} _add_one_file FILE=$${f};	\
	done)
	@echo "Archive created	${ARCHIVE}"

## Create an archive with RSAT/NeAT tools
tar_archive:
	@echo
	@echo "Creating tar archive with RSAT/NeAT tools"
	${MAKE} _create_tar_archive
	${MAKE} _fill_archive ARCHIVE_CMD='${TAR}' POST_CMD=''
	(cd ${TAR_ROOT}; gzip -f ${ARCHIVE}.tar)
	@echo
	@echo "Archive"
	@echo "	${TAR_ROOT}/${ARCHIVE}.tar.gz"

## Create an archive with the metabolic tools (since the java files occupy 80Mb, we releaseute them separately
tar_archive_metab:
	${MAKE} tar_archive ARCHIVE_PREFIX=${ARCHIVE_PREFIX_METAB} RELEASE_FILES="${RELEASE_FILES_METAB}"

#tar_archive_scripts:
#	${MAKE} tar_archive ARCHIVE_PREFIX=${ARCHIVE_PREFIX_SCRIPTS} RELEASE_FILES="${RELEASE_FILES_SCRIPTS}"

## Archive with zip
# ZIP_EXCLUDE=-x CVS '*~' tmp data logs
# ZIP =zip -ry ${ARCHIVE}.zip 
# zip_archive:
# 	${MAKE} _fill_archive ARCHIVE_CMD='${ZIP}' POST_CMD='${ZIP_EXCLUDE}'


ls_release_site:
	ssh ${SSH_OPT} ${PUB_LOGIN}@${PUB_SERVER} "ls -ltra ${PUB_DIR}/"

clean_release_site:
	@echo
	@echo "Moving previous archives from the public server ${PUB_LOGIN}@${PUB_SERVER} to ${PUB_DIR}/previous_versions"
	ssh ${SSH_OPT} ${PUB_LOGIN}@${PUB_SERVER} "mv -f ${PUB_DIR}/rsat_*.tar.gz ${PUB_DIR}/previous_versions/"
	@echo 
	@echo "BEWARE: the tar archives for RSAT code and install scripts have been moved to previous_version folder. "
	@echo "Do not forget to publish a new version with"
	@echo "	make -f makefiles/rsat_release.mk publish"

################################################################
## Publish the tar archive of the whole release
publish:
	@echo
	@echo "Synchronizing RSAT archive ${ARCHIVE_PREFIX}.${PUB_FORMAT} to server ${PUB_LOGIN}@${PUB_SERVER}:${PUB_DIR}"
	@echo
	rsync -ruptvl -e "ssh ${SSH_OPT}" ${ARCHIVE_PREFIX}.${PUB_FORMAT} ${PUB_LOGIN}@${PUB_SERVER}:${PUB_DIR}/

#publish_scripts:
#	@${MAKE} publish ARCHIVE_PREFIX=${ARCHIVE_PREFIX_SCRIPTS}


## Publish the appliance for RSAT VirtualBox Virtual Machine (VM)
APPLIANCE=rsat-vb-2017-04-22.ova
LOCAL_APPLIANCE_DIR=/no_backup/VirtualBox_VMs/RSAT-VM_00/appliances/
LOCAL_APPLIANCE=${LOCAL_APPLIANCE_DIR}/${APPLIANCE}
RSATVM_REPO=rsat@pedagogix-tagc.univ-mrs.fr:/data/rsat_release/virtual_machines/
RSATVM_TUTO=${RSAT}/doc/howto/RSAT-VM/RSAT-VM_tuto.html
publish_vm:
	@echo
	@echo "Synchronizing RSAT-VM	${APPLIANCE}"
	@echo "	LOCAL_APPLIANCE	${LOCAL_APPLIANCE}"
	@du -sm ${LOCAL_APPLIANCE}
	@rsync -ruptvl ${LOCAL_APPLIANCE}  ${RSATVM_REPO}

publish_vm_tuto:
	@echo
	@echo "Synchronizing RSAT-VM tutorial"
	@rsync -ruptvl ${RSATVM_TUTO}  ${RSATVM_REPO}
	@echo "Check the web site"
	@echo "	http://download.rsat.eu/virtual_machines/"
	@echo "	http://download.rsat.eu/virtual_machines/RSAT-VM_tuto.html"

publish_metab:
	@${MAKE} publish ARCHIVE_PREFIX=${ARCHIVE_PREFIX_METAB}

## Open the release Web site
BROWSER=firefox
web:
	 open -a ${BROWSER} ${RELEASE_URL}

################################################################
## Make a tar archive of the ws clients
TAR_WSCLIENTS=public_html/web_services/RSATWS_clients.tar.gz
tar_wsclients:
	@rm -f ${TAR_WSCLIENTS}
	tar \
	--exclude CVS  \
	--exclude '*~' \
	--exclude '*.DS_Store' -cpzf ${TAR_WSCLIENTS} ws_clients
	@echo ${TAR_WSCLIENTS}

publish_tar_wsclients:
	rsync -ruptvl -e "ssh ${SSH_OPT}" ${TAR_WSCLIENTS} ${PUB_LOGIN}@${PUB_SERVER}:rsat/public_html/web_services/

