package MyTypes::ConvertFeaturesRequest;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(0);

sub get_xmlns { 'urn:RSATWS' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %output_of :ATTR(:get<output>);
my %input_of :ATTR(:get<input>);
my %tmp_infile_of :ATTR(:get<tmp_infile>);
my %from_of :ATTR(:get<from>);
my %to_of :ATTR(:get<to>);
my %coord_of :ATTR(:get<coord>);

__PACKAGE__->_factory(
    [ qw(        output
        input
        tmp_infile
        from
        to
        coord

    ) ],
    {
        'output' => \%output_of,
        'input' => \%input_of,
        'tmp_infile' => \%tmp_infile_of,
        'from' => \%from_of,
        'to' => \%to_of,
        'coord' => \%coord_of,
    },
    {
        'output' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'input' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'tmp_infile' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'from' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'to' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'coord' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
    },
    {

        'output' => 'output',
        'input' => 'input',
        'tmp_infile' => 'tmp_infile',
        'from' => 'from',
        'to' => 'to',
        'coord' => 'coord',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

MyTypes::ConvertFeaturesRequest

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
ConvertFeaturesRequest from the namespace urn:RSATWS.

Parameters for the operation convert_features.




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * output


=item * input


=item * tmp_infile


=item * from


=item * to


=item * coord




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # MyTypes::ConvertFeaturesRequest
   output =>  $some_value, # string
   input =>  $some_value, # string
   tmp_infile =>  $some_value, # string
   from =>  $some_value, # string
   to =>  $some_value, # string
   coord =>  $some_value, # string
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

