package MyTypes::GraphNeighboursRequest;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(0);

sub get_xmlns { 'urn:RSATWS' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %output_of :ATTR(:get<output>);
my %informat_of :ATTR(:get<informat>);
my %direction_of :ATTR(:get<direction>);
my %all_of :ATTR(:get<all>);
my %stats_of :ATTR(:get<stats>);
my %self_of :ATTR(:get<self>);
my %inputgraph_of :ATTR(:get<inputgraph>);
my %seedfile_of :ATTR(:get<seedfile>);
my %wcol_of :ATTR(:get<wcol>);
my %scol_of :ATTR(:get<scol>);
my %tcol_of :ATTR(:get<tcol>);
my %steps_of :ATTR(:get<steps>);

__PACKAGE__->_factory(
    [ qw(        output
        informat
        direction
        all
        stats
        self
        inputgraph
        seedfile
        wcol
        scol
        tcol
        steps

    ) ],
    {
        'output' => \%output_of,
        'informat' => \%informat_of,
        'direction' => \%direction_of,
        'all' => \%all_of,
        'stats' => \%stats_of,
        'self' => \%self_of,
        'inputgraph' => \%inputgraph_of,
        'seedfile' => \%seedfile_of,
        'wcol' => \%wcol_of,
        'scol' => \%scol_of,
        'tcol' => \%tcol_of,
        'steps' => \%steps_of,
    },
    {
        'output' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'informat' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'direction' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'all' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'stats' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'self' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'inputgraph' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'seedfile' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'wcol' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'scol' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'tcol' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'steps' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
    },
    {

        'output' => 'output',
        'informat' => 'informat',
        'direction' => 'direction',
        'all' => 'all',
        'stats' => 'stats',
        'self' => 'self',
        'inputgraph' => 'inputgraph',
        'seedfile' => 'seedfile',
        'wcol' => 'wcol',
        'scol' => 'scol',
        'tcol' => 'tcol',
        'steps' => 'steps',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

MyTypes::GraphNeighboursRequest

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
GraphNeighboursRequest from the namespace urn:RSATWS.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * output


=item * informat


=item * direction


=item * all


=item * stats


=item * self


=item * inputgraph


=item * seedfile


=item * wcol


=item * scol


=item * tcol


=item * steps




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # MyTypes::GraphNeighboursRequest
   output =>  $some_value, # string
   informat =>  $some_value, # string
   direction =>  $some_value, # string
   all =>  $some_value, # int
   stats =>  $some_value, # int
   self =>  $some_value, # int
   inputgraph =>  $some_value, # string
   seedfile =>  $some_value, # string
   wcol =>  $some_value, # int
   scol =>  $some_value, # int
   tcol =>  $some_value, # int
   steps =>  $some_value, # int
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

