
package MyElements::compare_matrices;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'urn:RSATWS' }

__PACKAGE__->__set_name('compare_matrices');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();

use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    SOAP::WSDL::XSD::Typelib::ComplexType
);

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %request_of :ATTR(:get<request>);

__PACKAGE__->_factory(
    [ qw(        request

    ) ],
    {
        'request' => \%request_of,
    },
    {
        'request' => 'MyTypes::CompareMatricesRequest',
    },
    {

        'request' => 'request',
    }
);

} # end BLOCK






} # end of BLOCK



1;


=pod

=head1 NAME

MyElements::compare_matrices

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
compare_matrices from the namespace urn:RSATWS.







=head1 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * request

 $element->set_request($data);
 $element->get_request();





=back


=head1 METHODS

=head2 new

 my $element = MyElements::compare_matrices->new($data);

Constructor. The following data structure may be passed to new():

 {
   request =>  { # MyTypes::CompareMatricesRequest
     output =>  $some_value, # string
     matrix_1 =>  $some_value, # string
     matrix_2 =>  $some_value, # string
     matrix =>  $some_value, # string
     tmp_matrix1_infile =>  $some_value, # string
     tmp_matrix2_infile =>  $some_value, # string
     tmp_matrix_infile =>  $some_value, # string
     format1 =>  $some_value, # string
     format2 =>  $some_value, # string
     format =>  $some_value, # string
     background_model =>  $some_value, # string
     tmp_background_infile =>  $some_value, # string
     background_format =>  $some_value, # string
     top1 =>  $some_value, # int
     top2 =>  $some_value, # int
     output_prefix =>  $some_value, # string
     mode =>  $some_value, # string
     distinct =>  $some_value, # string
     strand =>  $some_value, # string
     matrix_id =>  $some_value, # string
     return =>  $some_value, # string
     sort =>  $some_value, # string
     lth =>  $some_value, # string
     uth =>  $some_value, # string
   },
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

