
package MyElements::position_analysis;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'urn:RSATWS' }

__PACKAGE__->__set_name('position_analysis');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();

use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    SOAP::WSDL::XSD::Typelib::ComplexType
);

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %request_of :ATTR(:get<request>);

__PACKAGE__->_factory(
    [ qw(        request

    ) ],
    {
        'request' => \%request_of,
    },
    {
        'request' => 'MyTypes::PositionAnalysisRequest',
    },
    {

        'request' => 'request',
    }
);

} # end BLOCK






} # end of BLOCK



1;


=pod

=head1 NAME

MyElements::position_analysis

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
position_analysis from the namespace urn:RSATWS.







=head1 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * request

 $element->set_request($data);
 $element->get_request();





=back


=head1 METHODS

=head2 new

 my $element = MyElements::position_analysis->new($data);

Constructor. The following data structure may be passed to new():

 {
   request =>  { # MyTypes::PositionAnalysisRequest
     output =>  $some_value, # string
     verbosity =>  $some_value, # int
     sequence =>  $some_value, # string
     tmp_infile =>  $some_value, # string
     format =>  $some_value, # string
     length =>  $some_value, # int
     seq_type =>  $some_value, # string
     last =>  $some_value, # int
     mask =>  $some_value, # string
     noov =>  $some_value, # int
     str =>  $some_value, # int
     class_int =>  $some_value, # int
     origin =>  $some_value, # string
     offset =>  $some_value, # int
     group_rc =>  $some_value, # int
     sort =>  $some_value, # int
     return =>  $some_value, # string
     lth_chi =>  $some_value, # int
     lth_sig =>  $some_value, # int
     lth_occ =>  $some_value, # int
     uth_rank =>  $some_value, # int
     max_graphs =>  $some_value, # int
     pattern =>  $some_value, # string
     tmp_pattern_infile =>  $some_value, # string
     score_column =>  $some_value, # int
     min_pos =>  $some_value, # int
     max_pos =>  $some_value, # int
     no_check =>  $some_value, # int
     no_filter =>  $some_value, # int
     image_format =>  $some_value, # string
     title =>  $some_value, # string
   },
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

