package MyTypes::FetchSequencesRequest;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(0);

sub get_xmlns { 'urn:RSATWS' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %output_of :ATTR(:get<output>);
my %input_of :ATTR(:get<input>);
my %tmp_input_file_of :ATTR(:get<tmp_input_file>);
my %url_of :ATTR(:get<url>);
my %genome_of :ATTR(:get<genome>);
my %header_format_of :ATTR(:get<header_format>);
my %upstr_ext_of :ATTR(:get<upstr_ext>);
my %downstr_ext_of :ATTR(:get<downstr_ext>);
my %extend_of :ATTR(:get<extend>);
my %reference_of :ATTR(:get<reference>);
my %top_of :ATTR(:get<top>);
my %chunck_of :ATTR(:get<chunck>);

__PACKAGE__->_factory(
    [ qw(        output
        input
        tmp_input_file
        url
        genome
        header_format
        upstr_ext
        downstr_ext
        extend
        reference
        top
        chunck

    ) ],
    {
        'output' => \%output_of,
        'input' => \%input_of,
        'tmp_input_file' => \%tmp_input_file_of,
        'url' => \%url_of,
        'genome' => \%genome_of,
        'header_format' => \%header_format_of,
        'upstr_ext' => \%upstr_ext_of,
        'downstr_ext' => \%downstr_ext_of,
        'extend' => \%extend_of,
        'reference' => \%reference_of,
        'top' => \%top_of,
        'chunck' => \%chunck_of,
    },
    {
        'output' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'input' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'tmp_input_file' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'url' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'genome' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'header_format' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'upstr_ext' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'downstr_ext' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'extend' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'reference' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'top' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'chunck' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
    },
    {

        'output' => 'output',
        'input' => 'input',
        'tmp_input_file' => 'tmp_input_file',
        'url' => 'url',
        'genome' => 'genome',
        'header_format' => 'header_format',
        'upstr_ext' => 'upstr_ext',
        'downstr_ext' => 'downstr_ext',
        'extend' => 'extend',
        'reference' => 'reference',
        'top' => 'top',
        'chunck' => 'chunck',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

MyTypes::FetchSequencesRequest

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
FetchSequencesRequest from the namespace urn:RSATWS.

Parameters for the operation fetch_sequences.




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * output


=item * input


=item * tmp_input_file


=item * url


=item * genome


=item * header_format


=item * upstr_ext


=item * downstr_ext


=item * extend


=item * reference


=item * top


=item * chunck




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # MyTypes::FetchSequencesRequest
   output =>  $some_value, # string
   input =>  $some_value, # string
   tmp_input_file =>  $some_value, # string
   url =>  $some_value, # string
   genome =>  $some_value, # string
   header_format =>  $some_value, # string
   upstr_ext =>  $some_value, # int
   downstr_ext =>  $some_value, # int
   extend =>  $some_value, # int
   reference =>  $some_value, # string
   top =>  $some_value, # int
   chunck =>  $some_value, # int
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

