package MyTypes::GetOrthologsRequest;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(0);

sub get_xmlns { 'urn:RSATWS' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %output_of :ATTR(:get<output>);
my %organism_of :ATTR(:get<organism>);
my %taxon_of :ATTR(:get<taxon>);
my %query_of :ATTR(:get<query>);
my %all_of :ATTR(:get<all>);
my %nogrep_of :ATTR(:get<nogrep>);
my %return_of :ATTR(:get<return>);
my %lth_of :ATTR(:get<lth>);
my %uth_of :ATTR(:get<uth>);

__PACKAGE__->_factory(
    [ qw(        output
        organism
        taxon
        query
        all
        nogrep
        return
        lth
        uth

    ) ],
    {
        'output' => \%output_of,
        'organism' => \%organism_of,
        'taxon' => \%taxon_of,
        'query' => \%query_of,
        'all' => \%all_of,
        'nogrep' => \%nogrep_of,
        'return' => \%return_of,
        'lth' => \%lth_of,
        'uth' => \%uth_of,
    },
    {
        'output' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'organism' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'taxon' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'query' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'all' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'nogrep' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'return' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'lth' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'uth' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
    },
    {

        'output' => 'output',
        'organism' => 'organism',
        'taxon' => 'taxon',
        'query' => 'query',
        'all' => 'all',
        'nogrep' => 'nogrep',
        'return' => 'return',
        'lth' => 'lth',
        'uth' => 'uth',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

MyTypes::GetOrthologsRequest

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
GetOrthologsRequest from the namespace urn:RSATWS.

Parameters for the operation get_orthologs.




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * output


=item * organism


=item * taxon


=item * query


=item * all


=item * nogrep


=item * return


=item * lth


=item * uth




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # MyTypes::GetOrthologsRequest
   output =>  $some_value, # string
   organism =>  $some_value, # string
   taxon =>  $some_value, # string
   query =>  $some_value, # string
   all =>  $some_value, # int
   nogrep =>  $some_value, # int
   return =>  $some_value, # string
   lth =>  $some_value, # string
   uth =>  $some_value, # string
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

