#!/usr/bin/python
#-*-coding: utf-8-*-

"""Version: v0.1
Description: this program was developed in order to get informations 
on all studied species'genes available on the MICROME server. It runs only in Python 2.7.
Authors: alexandra.bomane@laposte.net, mel.colombier@free.fr
Usage: python gene2reaction_from_microme.py [-o outfile_name] [--output_file outfile_name] [-org organism_name]
Options: 
    -h  Display full help message
    -help
        Same as -h
    -o outfile_name
        If no output file is specified, the standard output is used.
    --output_file outfile_name
        Same as -o
    -org organism_name
        Chosen organism to get its informations
"""

import json #For parsing the server response
import time #To add the current date to the standard file name
import argparse #To add options
from workflows_functions import RequestMicrome #To send our request to the MICROME server

if __name__=='__main__':

    print "; Job started", time.strftime("%Y-%m-%d_%Hh%M")
    
    try:    
        #Current date
        date = time.strftime("%Y_%m_%d")
        
        # ext is the extension of the url request
        ext = "/genomes.json"
        
        # A JSON object is returned
        content = RequestMicrome(ext)
        
        #Creation of arguments    
        parser = argparse.ArgumentParser(add_help = True)
        parser.add_argument('-o', action = 'store', dest = 'outfile_n', default = False, help = 'The user can choose the outfile name')
        parser.add_argument('--output_file', action = 'store', dest = 'outfileN', default = False, help = 'The user can choose the outfile name')
        parser.add_argument('-org', action = 'store' , dest = 'organism', default = None, help = 'The user\'s chosen organism')
        args = parser.parse_args()
        
        organism, outfile_n, outfileN = args.organism, args.outfile_n, args.outfileN    
        
        # Choose of outfile name
        if outfile_n:
            outfile = outfile_n #File name chosen by the user
        elif outfileN:
                outfile = outfileN #File name chosen by the user
        else:
            outfile = "gene2reaction_from_microme_" + date + ".tab" #Standard file name according to the date
        
        #Getting of the JSON object
        decoded = json.loads(content)
        
        #Creation of a dictionary containing some informations about the studied organism
        info_species = {} 
        
        
        #Feeding of the dictionary
        organism = organism.replace("_"," ")
        for i in range(len(decoded)):
            dict_species = decoded[i]
            if organism in dict_species[u'name']:
                info_species['Assembly accession'] = str(dict_species[u'assembly_ac'])
                info_species['NcbiID'] = str(dict_species[u'taxonomy_id'])
                info_species['Organism Name'] = str(dict_species[u'name'])
                
        
        #New request to get more informations
        org_id = info_species['Assembly accession']
        ext2 = "/genomes/" + org_id + "/GPRs/InterPro.json" 
        content2 = RequestMicrome(ext2)
        
        #Getting of the JSON object        
        decoded2 = json.loads(content2)
        
        print decoded2.keys()
        
    except AttributeError:
        print "Enter an organism's name in argument, please ! \nRecall : -org My_Organism's_Name"    
        
        
        print "; Job done, Job name :", outfile, time.strftime("%Y-%m-%d_%Hh%M")
