
package MyElements::fetch_sequences;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'urn:RSATWS' }

__PACKAGE__->__set_name('fetch_sequences');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();

use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    SOAP::WSDL::XSD::Typelib::ComplexType
);

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %request_of :ATTR(:get<request>);

__PACKAGE__->_factory(
    [ qw(        request

    ) ],
    {
        'request' => \%request_of,
    },
    {
        'request' => 'MyTypes::FetchSequencesRequest',
    },
    {

        'request' => 'request',
    }
);

} # end BLOCK






} # end of BLOCK



1;


=pod

=head1 NAME

MyElements::fetch_sequences

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
fetch_sequences from the namespace urn:RSATWS.







=head1 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * request

 $element->set_request($data);
 $element->get_request();





=back


=head1 METHODS

=head2 new

 my $element = MyElements::fetch_sequences->new($data);

Constructor. The following data structure may be passed to new():

 {
   request =>  { # MyTypes::FetchSequencesRequest
     output =>  $some_value, # string
     input =>  $some_value, # string
     tmp_input_file =>  $some_value, # string
     url =>  $some_value, # string
     genome =>  $some_value, # string
     header_format =>  $some_value, # string
     upstr_ext =>  $some_value, # int
     downstr_ext =>  $some_value, # int
     extend =>  $some_value, # int
     reference =>  $some_value, # string
     top =>  $some_value, # int
     chunck =>  $some_value, # int
   },
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

