
package MyElements::random_seq;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'urn:RSATWS' }

__PACKAGE__->__set_name('random_seq');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();

use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    SOAP::WSDL::XSD::Typelib::ComplexType
);

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %request_of :ATTR(:get<request>);

__PACKAGE__->_factory(
    [ qw(        request

    ) ],
    {
        'request' => \%request_of,
    },
    {
        'request' => 'MyTypes::RandomSequenceRequest',
    },
    {

        'request' => 'request',
    }
);

} # end BLOCK






} # end of BLOCK



1;


=pod

=head1 NAME

MyElements::random_seq

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
random_seq from the namespace urn:RSATWS.







=head1 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * request

 $element->set_request($data);
 $element->get_request();





=back


=head1 METHODS

=head2 new

 my $element = MyElements::random_seq->new($data);

Constructor. The following data structure may be passed to new():

 {
   request =>  { # MyTypes::RandomSequenceRequest
     output =>  $some_value, # string
     sequence_length =>  $some_value, # int
     repetition =>  $some_value, # int
     format =>  $some_value, # string
     line_width =>  $some_value, # int
     type =>  $some_value, # string
     seed =>  $some_value, # int
     alphabet =>  $some_value, # string
     expfreq =>  $some_value, # string
     tmp_expfreq_file =>  $some_value, # string
     bg_model =>  $some_value, # string
     organism =>  $some_value, # string
     oligo_length =>  $some_value, # int
     length_file =>  $some_value, # string
   },
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

