package MyTypes::ConvertSeqRequest;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(0);

sub get_xmlns { 'urn:RSATWS' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %output_of :ATTR(:get<output>);
my %sequence_of :ATTR(:get<sequence>);
my %tmp_infile_of :ATTR(:get<tmp_infile>);
my %from_of :ATTR(:get<from>);
my %to_of :ATTR(:get<to>);

__PACKAGE__->_factory(
    [ qw(        output
        sequence
        tmp_infile
        from
        to

    ) ],
    {
        'output' => \%output_of,
        'sequence' => \%sequence_of,
        'tmp_infile' => \%tmp_infile_of,
        'from' => \%from_of,
        'to' => \%to_of,
    },
    {
        'output' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'sequence' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'tmp_infile' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'from' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'to' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
    },
    {

        'output' => 'output',
        'sequence' => 'sequence',
        'tmp_infile' => 'tmp_infile',
        'from' => 'from',
        'to' => 'to',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

MyTypes::ConvertSeqRequest

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
ConvertSeqRequest from the namespace urn:RSATWS.

Parameters for the operation convert_seq.




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * output


=item * sequence


=item * tmp_infile


=item * from


=item * to




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # MyTypes::ConvertSeqRequest
   output =>  $some_value, # string
   sequence =>  $some_value, # string
   tmp_infile =>  $some_value, # string
   from =>  $some_value, # string
   to =>  $some_value, # string
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

