package MyTypes::GraphClusterMembershipRequest;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(0);

sub get_xmlns { 'urn:RSATWS' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %output_of :ATTR(:get<output>);
my %informat_of :ATTR(:get<informat>);
my %inputgraph_of :ATTR(:get<inputgraph>);
my %clusters_of :ATTR(:get<clusters>);
my %stat_of :ATTR(:get<stat>);
my %decimals_of :ATTR(:get<decimals>);
my %wcol_of :ATTR(:get<wcol>);
my %scol_of :ATTR(:get<scol>);
my %tcol_of :ATTR(:get<tcol>);

__PACKAGE__->_factory(
    [ qw(        output
        informat
        inputgraph
        clusters
        stat
        decimals
        wcol
        scol
        tcol

    ) ],
    {
        'output' => \%output_of,
        'informat' => \%informat_of,
        'inputgraph' => \%inputgraph_of,
        'clusters' => \%clusters_of,
        'stat' => \%stat_of,
        'decimals' => \%decimals_of,
        'wcol' => \%wcol_of,
        'scol' => \%scol_of,
        'tcol' => \%tcol_of,
    },
    {
        'output' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'informat' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'inputgraph' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'clusters' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'stat' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'decimals' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'wcol' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'scol' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'tcol' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
    },
    {

        'output' => 'output',
        'informat' => 'informat',
        'inputgraph' => 'inputgraph',
        'clusters' => 'clusters',
        'stat' => 'stat',
        'decimals' => 'decimals',
        'wcol' => 'wcol',
        'scol' => 'scol',
        'tcol' => 'tcol',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

MyTypes::GraphClusterMembershipRequest

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
GraphClusterMembershipRequest from the namespace urn:RSATWS.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * output


=item * informat


=item * inputgraph


=item * clusters


=item * stat


=item * decimals


=item * wcol


=item * scol


=item * tcol




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # MyTypes::GraphClusterMembershipRequest
   output =>  $some_value, # string
   informat =>  $some_value, # string
   inputgraph =>  $some_value, # string
   clusters =>  $some_value, # string
   stat =>  $some_value, # string
   decimals =>  $some_value, # int
   wcol =>  $some_value, # int
   scol =>  $some_value, # int
   tcol =>  $some_value, # int
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

