
package MyElements::dna_pattern;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'urn:RSATWS' }

__PACKAGE__->__set_name('dna_pattern');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();

use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    SOAP::WSDL::XSD::Typelib::ComplexType
);

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %request_of :ATTR(:get<request>);

__PACKAGE__->_factory(
    [ qw(        request

    ) ],
    {
        'request' => \%request_of,
    },
    {
        'request' => 'MyTypes::DnaPatternRequest',
    },
    {

        'request' => 'request',
    }
);

} # end BLOCK






} # end of BLOCK



1;


=pod

=head1 NAME

MyElements::dna_pattern

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
dna_pattern from the namespace urn:RSATWS.





=head1 METHODS

=head2 new

 my $element = MyElements::dna_pattern->new($data);

Constructor. The following data structure may be passed to new():

 {
   request =>  { # MyTypes::DnaPatternRequest
     output =>  $some_value, # string
     sequence =>  $some_value, # string
     tmp_infile =>  $some_value, # string
     format =>  $some_value, # string
     subst =>  $some_value, # int
     pattern =>  $some_value, # string
     pattern_file =>  $some_value, # string
     tmp_pattern_file =>  $some_value, # string
     id =>  $some_value, # string
     origin =>  $some_value, # string
     noov =>  $some_value, # int
     score =>  $some_value, # int
     str =>  $some_value, # int
     sort =>  $some_value, # int
     th =>  $some_value, # int
     return =>  $some_value, # string
   },
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

