package MyTypes::InferOperonRequest;
use strict;
use warnings;


our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %output_of :ATTR(:get<output>);
my %organism_of :ATTR(:get<organism>);
my %query_of :ATTR(:get<query>);
my %tmp_infile_of :ATTR(:get<tmp_infile>);
my %all_of :ATTR(:get<all>);
my %distance_of :ATTR(:get<distance>);
my %return_of :ATTR(:get<return>);

__PACKAGE__->_factory(
    [ qw(        output
        organism
        query
        tmp_infile
        all
        distance
        return

    ) ],
    {
        'output' => \%output_of,
        'organism' => \%organism_of,
        'query' => \%query_of,
        'tmp_infile' => \%tmp_infile_of,
        'all' => \%all_of,
        'distance' => \%distance_of,
        'return' => \%return_of,
    },
    {
        'output' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'organism' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'query' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'tmp_infile' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'all' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'distance' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'return' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
    },
    {

        'output' => 'output',
        'organism' => 'organism',
        'query' => 'query',
        'tmp_infile' => 'tmp_infile',
        'all' => 'all',
        'distance' => 'distance',
        'return' => 'return',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

MyTypes::InferOperonRequest

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
InferOperonRequest from the namespace urn:RSATWS.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * output


=item * organism


=item * query


=item * tmp_infile


=item * all


=item * distance


=item * return




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # MyTypes::InferOperonRequest
   output =>  $some_value, # string
   organism =>  $some_value, # string
   query =>  $some_value, # string
   tmp_infile =>  $some_value, # string
   all =>  $some_value, # int
   distance =>  $some_value, # int
   return =>  $some_value, # string
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

