package MyTypes::GetResultResponse;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(0);

sub get_xmlns { 'urn:RSATWS' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %client_of :ATTR(:get<client>);
my %server_of :ATTR(:get<server>);

__PACKAGE__->_factory(
    [ qw(        client
        server

    ) ],
    {
        'client' => \%client_of,
        'server' => \%server_of,
    },
    {
        'client' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'server' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
    },
    {

        'client' => 'client',
        'server' => 'server',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

MyTypes::GetResultResponse

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
GetResultResponse from the namespace urn:RSATWS.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * client


=item * server




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # MyTypes::GetResultResponse
   client =>  $some_value, # string
   server =>  $some_value, # string
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

