
package MyElements::matrix_scan;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'urn:RSATWS' }

__PACKAGE__->__set_name('matrix_scan');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();

use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    SOAP::WSDL::XSD::Typelib::ComplexType
);

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %request_of :ATTR(:get<request>);

__PACKAGE__->_factory(
    [ qw(        request

    ) ],
    {
        'request' => \%request_of,
    },
    {
        'request' => 'MyTypes::MatrixScanRequest',
    },
    {

        'request' => 'request',
    }
);

} # end BLOCK






} # end of BLOCK



1;


=pod

=head1 NAME

MyElements::matrix_scan

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
matrix_scan from the namespace urn:RSATWS.





=head1 METHODS

=head2 new

 my $element = MyElements::matrix_scan->new($data);

Constructor. The following data structure may be passed to new():

 {
   request =>  { # MyTypes::MatrixScanRequest
     output =>  $some_value, # string
     sequence =>  $some_value, # string
     tmp_sequence_infile =>  $some_value, # string
     matrix =>  $some_value, # string
     tmp_matrix_infile =>  $some_value, # string
     sequence_format =>  $some_value, # string
     matrix_format =>  $some_value, # string
     n_treatment =>  $some_value, # string
     consensus_name =>  $some_value, # string
     pseudo =>  $some_value, # int
     equi_pseudo =>  $some_value, # int
     top_matrices =>  $some_value, # int
     background_model =>  $some_value, # string
     tmp_background_infile =>  $some_value, # string
     organism =>  $some_value, # string
     background =>  $some_value, # string
     background_input =>  $some_value, # int
     background_window =>  $some_value, # int
     markov =>  $some_value, # int
     background_pseudo =>  $some_value, # float
     return_fields =>  $some_value, # string
     sort_distrib =>  $some_value, # int
     lth =>  $some_value, # string
     uth =>  $some_value, # string
     str =>  $some_value, # int
     verbosity =>  $some_value, # int
     origin =>  $some_value, # string
     decimals =>  $some_value, # int
     crer_ids =>  $some_value, # int
   },
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

