################################################################
## Test the rsat subcommands

targets:
	@echo "Targets"
	@echo "	targets			list targets of this makefile"
	@echo "	all			run all the targets (may take some time)"
	@echo "	list_param		list parameters"
	@echo "	randseq			random-seq"

################################################################
## List global parameters
V=1
RESULT_DIR=rsat_rest_results
HOST='http://rsat-tagc.univ-mrs.fr/rsat/rest/'
list_param:
	@echo "rsat path	`which rsat`"
	@echo "	RESULT_DIR	${RESULT_DIR}"

################################################################
## Run all targets
all: targets list_param randseq


################################################################
## Generate random sequences
RANDSEQ_DIR=${RESULT_DIR}/random-seq_result
RANDSEQ=${RANDSEQ_DIR}/randseq_l1000_n10.fasta
randseq:
	@echo "Testing random-seq REST service"
	@mkdir -p ${RANDSEQ_DIR}
	@echo "	RANDSEQ_DIR	${RANDSEQ_DIR}"
	@echo "	Generating random sequences"
	@curl -X GET '${HOST}random-seq/?l=1000&n=10&seed=123&content-type=text%2Fplain' > ${RANDSEQ}
	@echo "	RANDSEQ		${RANDSEQ}"