#!/usr/bin/env python
'''NAME
        sort-matrix

VERSION
        1.0.0

AUTHOR
        Walter Santana <wsantana@lcg.unam.mx>

DESCRIPTION
        Sorts a list of matrices generated by variation-scan in decreasing length order

CATEGORY
        matrix

USAGE
    sort-matrix.py -i # -o #

ARGUMENTS
    -i #                   Mandatory option. Expects a list of matrix and distrib files generated from variation-scan.
    -o #                   Mandatory option. Expects a file name for the sorted file according to matrix lengths.

SEE ALSO
        variation-scan
        retrieve-variation-seq
        convert-variations
        variation-info
'''

# ===========================================================================
# =                            imports
# ===========================================================================
import argparse
import re

# ===========================================================================
# =                            functions
# ===========================================================================
def get_matrix_len(matrix_file):
    """
    Calculates matrix length by reading a matrix in tab format.
    """
    # Read file
    fh_input = open(matrix_file, 'r')

    for line in fh_input:
        length = len(line.split("\t")) - 1
        break

    return length
# ===========================================================================
# =                            main
# ===========================================================================
if __name__ == '__main__':
    # Arguments definition
    parse = argparse.ArgumentParser()
    parse.add_argument('-i',  action = 'store', dest='ifile', required = True, help = "Mandatory option. Expects a list of matrix and distrib files generated from variation-scan.")
    parse.add_argument('-o',  action = 'store', dest='ofile', required = True, help = "Mandatory option. Expects a file name for the sorted file according to matrix lengths.")

    # Arguments extraction
    args  = parse.parse_args()
    ifile = args.ifile
    ofile = args.ofile

    # Regular expressions
    regex_comment = re.compile(r";|#")

    # Initialize variables
    matrices    = {}
    m_size_list = []

    # Read file
    fh_input = open(ifile, 'r')

    for line in fh_input:
        # Skip head lines
        if regex_comment.match(line):
            continue
        token = line.rstrip().split("\t")

        # Add info for each matrix file
        matrices[token[2]] = token

        # Calcuate matrix length
        matrix_len = get_matrix_len(token[2])
        m_size_list.append([matrix_len, token[2]])

        #Sort matrix list by size
        m_size_list = sorted(m_size_list, key=lambda m_sizelist: m_sizelist[0], reverse = True)

        # Open output file and print header
        fh_output = open(ofile, 'w')
        fh_output.write("#MATRIX_PREFIX\tMATRIX_ID\tMATRIX_FILE\tMATRIX_SIZE\tDISTRIB_FILE\tDB\tBG_PREFIX\n")

        # Print to file
        for size in m_size_list:
            fh_output.write("{0}\t{1}\t{2}\t{3}\t{4}\t{5}\t{6}\n".format(matrices[size[1]][0],matrices[size[1]][1],
            matrices[size[1]][2],size[0],matrices[size[1]][3],matrices[size[1]][4],matrices[size[1]][5] ) )
