package MyTypes::RandomSequenceRequest;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(0);

sub get_xmlns { 'urn:RSATWS' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %output_of :ATTR(:get<output>);
my %sequence_length_of :ATTR(:get<sequence_length>);
my %repetition_of :ATTR(:get<repetition>);
my %format_of :ATTR(:get<format>);
my %line_width_of :ATTR(:get<line_width>);
my %type_of :ATTR(:get<type>);
my %seed_of :ATTR(:get<seed>);
my %alphabet_of :ATTR(:get<alphabet>);
my %expfreq_of :ATTR(:get<expfreq>);
my %tmp_expfreq_file_of :ATTR(:get<tmp_expfreq_file>);
my %bg_model_of :ATTR(:get<bg_model>);
my %organism_of :ATTR(:get<organism>);
my %oligo_length_of :ATTR(:get<oligo_length>);
my %length_file_of :ATTR(:get<length_file>);

__PACKAGE__->_factory(
    [ qw(        output
        sequence_length
        repetition
        format
        line_width
        type
        seed
        alphabet
        expfreq
        tmp_expfreq_file
        bg_model
        organism
        oligo_length
        length_file

    ) ],
    {
        'output' => \%output_of,
        'sequence_length' => \%sequence_length_of,
        'repetition' => \%repetition_of,
        'format' => \%format_of,
        'line_width' => \%line_width_of,
        'type' => \%type_of,
        'seed' => \%seed_of,
        'alphabet' => \%alphabet_of,
        'expfreq' => \%expfreq_of,
        'tmp_expfreq_file' => \%tmp_expfreq_file_of,
        'bg_model' => \%bg_model_of,
        'organism' => \%organism_of,
        'oligo_length' => \%oligo_length_of,
        'length_file' => \%length_file_of,
    },
    {
        'output' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'sequence_length' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'repetition' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'format' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'line_width' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'type' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'seed' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'alphabet' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'expfreq' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'tmp_expfreq_file' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'bg_model' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'organism' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'oligo_length' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'length_file' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
    },
    {

        'output' => 'output',
        'sequence_length' => 'sequence_length',
        'repetition' => 'repetition',
        'format' => 'format',
        'line_width' => 'line_width',
        'type' => 'type',
        'seed' => 'seed',
        'alphabet' => 'alphabet',
        'expfreq' => 'expfreq',
        'tmp_expfreq_file' => 'tmp_expfreq_file',
        'bg_model' => 'bg_model',
        'organism' => 'organism',
        'oligo_length' => 'oligo_length',
        'length_file' => 'length_file',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

MyTypes::RandomSequenceRequest

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
RandomSequenceRequest from the namespace urn:RSATWS.

Parameters for the operation random_seq.




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * output


=item * sequence_length


=item * repetition


=item * format


=item * line_width


=item * type


=item * seed


=item * alphabet


=item * expfreq


=item * tmp_expfreq_file


=item * bg_model


=item * organism


=item * oligo_length


=item * length_file




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # MyTypes::RandomSequenceRequest
   output =>  $some_value, # string
   sequence_length =>  $some_value, # int
   repetition =>  $some_value, # int
   format =>  $some_value, # string
   line_width =>  $some_value, # int
   type =>  $some_value, # string
   seed =>  $some_value, # int
   alphabet =>  $some_value, # string
   expfreq =>  $some_value, # string
   tmp_expfreq_file =>  $some_value, # string
   bg_model =>  $some_value, # string
   organism =>  $some_value, # string
   oligo_length =>  $some_value, # int
   length_file =>  $some_value, # string
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

